// Copyright (C) 2025 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

// Built-in constants.
const int gl_MaxVertexAttribs = 16;
const int gl_MaxVertexUniformVectors = 256;
const int gl_MaxVertexUniformComponents = 1024;
const int gl_MaxVertexOutputComponents = 64;
const int gl_MaxVaryingComponents = 60;        // Deprecated
const int gl_MaxVaryingVectors = 15;
const int gl_MaxVertexTextureImageUnits = 16;
const int gl_MaxVertexImageUniforms = 0;
const int gl_MaxVertexAtomicCounters = 0;
const int gl_MaxVertexAtomicCounterBuffers = 0;

const int gl_MaxTessPatchComponents = 120;
const int gl_MaxPatchVertices = 32;
const int gl_MaxTessGenLevel = 64;

const int gl_MaxTessControlInputComponents = 128;
const int gl_MaxTessControlOutputComponents = 128;
const int gl_MaxTessControlTextureImageUnits = 16;
const int gl_MaxTessControlUniformComponents = 1024;
const int gl_MaxTessControlTotalOutputComponents = 4096;
const int gl_MaxTessControlImageUniforms = 0;
const int gl_MaxTessControlAtomicCounters = 0;
const int gl_MaxTessControlAtomicCounterBuffers = 0;

const int gl_MaxTessEvaluationInputComponents = 128;
const int gl_MaxTessEvaluationOutputComponents = 128;
const int gl_MaxTessEvaluationTextureImageUnits = 16;
const int gl_MaxTessEvaluationUniformComponents = 1024;
const int gl_MaxTessEvaluationImageUniforms = 0;
const int gl_MaxTessEvaluationAtomicCounters = 0;
const int gl_MaxTessEvaluationAtomicCounterBuffers = 0;

const int gl_MaxGeometryInputComponents = 64;
const int gl_MaxGeometryOutputComponents = 128;
const int gl_MaxGeometryImageUniforms = 0;
const int gl_MaxGeometryTextureImageUnits = 16;
const int gl_MaxGeometryOutputVertices = 256;
const int gl_MaxGeometryTotalOutputComponents = 1024;
const int gl_MaxGeometryUniformComponents = 1024;
const int gl_MaxGeometryVaryingComponents = 64;
const int gl_MaxGeometryAtomicCounters = 0;
const int gl_MaxGeometryAtomicCounterBuffers = 0;

const int gl_MaxFragmentImageUniforms = 8;
const int gl_MaxFragmentInputComponents = 128;
const int gl_MaxFragmentUniformVectors = 256;
const int gl_MaxFragmentUniformComponents = 1024;
const int gl_MaxFragmentAtomicCounters = 8;
const int gl_MaxFragmentAtomicCounterBuffers = 1;


const int gl_MaxDrawBuffers = 8;
const int gl_MaxTextureImageUnits = 16;
const int gl_MinProgramTexelOffset = -8;
const int gl_MaxProgramTexelOffset = 7;
const int gl_MaxImageUnits = 8;
const int gl_MaxSamples = 4;
const int gl_MaxImageSamples = 0;
const int gl_MaxClipDistances = 8;
const int gl_MaxCullDistances = 8;
const int gl_MaxViewPorts = 16;

const int gl_MaxComputeImageUniforms = 8;
const ivec3 gl_MaxComputeWorkGroupCount = {65535, 65535, 65535};
const ivec3 gl_MaxComputeWorkGroupSize = {1024, 1024, 64};
const int gl_MaxComputeUniformComponents = 1024;
const int gl_MaxComputeTextureImageUnits = 16;
const int gl_MaxComputeAtomicCounters = 8;
const int gl_MaxComputeAtomicCounterBuffers = 8;

const int gl_MaxCombinedTextureImageUnits = 96;
const int gl_MaxCombinedImageUniforms = 48;
const int gl_MaxCombinedImageUnitsAndFragmentsOutputs = 8;  // deprecated
const int gl_MaxCombinedShaderOutputResources = 16;
const int gl_MaxCombinedAtomicCounters = 8;
const int gl_MaxCombinedAtomicCounterBuffers = 1;
const int gl_MaxCombinedClipAndCullDistances = 8;
const int gl_MaxAtomicCounterBindings = 1;
const int gl_MaxAtomicCounterBufferSize = 32;

const int gl_MaxTransformFeedbackBuffers = 4;
const int gl_MaxTransformFeedbackInterleavedComponents = 64;

const highp int gl_MaxInputAttachments = 1;

// Compatibility profile built-in constants.
const int gl_MaxTextureUnits = 2;
const int gl_MaxTextureCoords = 8;
const int gl_MaxClipPlanes = 8;
const int gl_MaxVaryingFloats = 60;

const int gl_MaxLights = 8;

// Compatibility profile built-in uniform state.
uniform mat4 gl_ModelViewMatrix;
uniform mat4 gl_ProjectionMatrix;
uniform mat4 gl_ModelViewProjectionMatrix;
uniform mat4 gl_TextureMatrix[gl_MaxTextureCoords];
uniform mat3 gl_NormalMatrix;
uniform mat4 gl_ModelViewMatrixInverse;
uniform mat4 gl_ProjectionMatrixInverse;
uniform mat4 gl_ModelViewProjectionMatrixInverse;
uniform mat4 gl_TextureMatrixInverse[gl_MaxTextureCoords];
uniform mat4 gl_ModelViewMatrixTranspose;
uniform mat4 gl_ProjectionMatrixTranspose;
uniform mat4 gl_ModelViewProjectionMatrixTranspose;
uniform mat4 gl_TextureMatrixTranspose[gl_MaxTextureCoords];
uniform mat4 gl_ModelViewMatrixInverseTranspose;
uniform mat4 gl_ProjectionMatrixInverseTranspose;
uniform mat4 gl_ModelViewProjectionMatrixInverseTranspose;
uniform mat4 gl_TextureMatrixInverseTranspose[gl_MaxTextureCoords];
uniform float gl_NormalScale;
uniform vec4 gl_ClipPlane[gl_MaxClipPlanes];

struct gl_PointParameters {
    float size;
    float sizeMin;
    float sizeMax;
    float fadeThresholdSize;
    float distanceConstantAttenuation;
    float distanceLinearAttenuation;
    float distanceQuadraticAttenuation;
};
uniform gl_PointParameters gl_Point;

struct gl_MaterialParameters {
    vec4 emission;
    vec4 ambient;
    vec4 diffuse;
    vec4 specular;
    float shininess;
};
uniform gl_MaterialParameters gl_FrontMaterial;
uniform gl_MaterialParameters gl_BackMaterial;

struct gl_LightSourceParameters {
    vec4 ambient;
    vec4 diffuse;
    vec4 specular;
    vec4 position;
    vec4 halfVector;
    vec3 spotDirection;
    float spotExponent;
    float spotCutoff;
    float spotCosCutoff;
    float constantAttenuation;
    float linearAttenuation;
    float quadraticAttenuation;
};
uniform gl_LightSourceParameters gl_LightSource[gl_MaxLights];

struct gl_LightModelParameters {
    vec4 ambient;
};
uniform gl_LightModelParameters gl_LightModel;

struct gl_LightModelProducts {
    vec4 sceneColor;
};
uniform gl_LightModelProducts gl_FrontLightModelProduct;
uniform gl_LightModelProducts gl_BackLightModelProduct;

struct gl_LightProducts {
    vec4 ambient;
    vec4 diffuse;
    vec4 specular;
};
uniform gl_LightProducts gl_FrontLightProduct[gl_MaxLights];
uniform gl_LightProducts gl_BackLightProduct[gl_MaxLights];

uniform vec4 gl_TextureEnvColor[gl_MaxTextureUnits];
uniform vec4 gl_EyePlaneS[gl_MaxTextureCoords];
uniform vec4 gl_EyePlaneT[gl_MaxTextureCoords];
uniform vec4 gl_EyePlaneR[gl_MaxTextureCoords];
uniform vec4 gl_EyePlaneQ[gl_MaxTextureCoords];
uniform vec4 gl_ObjectPlaneS[gl_MaxTextureCoords];
uniform vec4 gl_ObjectPlaneT[gl_MaxTextureCoords];
uniform vec4 gl_ObjectPlaneR[gl_MaxTextureCoords];
uniform vec4 gl_ObjectPlaneQ[gl_MaxTextureCoords];

struct gl_FogParameters {
    vec4 color;
    float density;
    float start;
    float end;
    float scale;
};
uniform gl_FogParameters gl_Fog;

// Angle and trigonometry functions.
float radians(float degrees);
vec2 radians(vec2 degrees);
vec3 radians(vec3 degrees);
vec4 radians(vec4 degrees);
float degrees(float radians);
vec2 degrees(vec2 radians);
vec3 degrees(vec3 radians);
vec4 degrees(vec4 radians);
float sin(float angle);
vec2 sin(vec2 angle);
vec3 sin(vec3 angle);
vec4 sin(vec4 angle);
float cos(float angle);
vec2 cos(vec2 angle);
vec3 cos(vec3 angle);
vec4 cos(vec4 angle);
float tan(float angle);
vec2 tan(vec2 angle);
vec3 tan(vec3 angle);
vec4 tan(vec4 angle);
float asin(float angle);
vec2 asin(vec2 angle);
vec3 asin(vec3 angle);
vec4 asin(vec4 angle);
float acos(float angle);
vec2 acos(vec2 angle);
vec3 acos(vec3 angle);
vec4 acos(vec4 angle);
float atan(float y, float x);
vec2 atan(vec2 y, vec2 x);
vec3 atan(vec3 y, vec3 x);
vec4 atan(vec4 y, vec4 x);
float atan(float y_over_x);
vec2 atan(vec2 y_over_x);
vec3 atan(vec3 y_over_x);
vec4 atan(vec4 y_over_x);
float sinh(float x);
vec2 sinh(vec2 x);
vec3 sinh(vec3 x);
vec4 sinh(vec4 x);
float cosh(float x);
vec2 cosh(vec2 x);
vec3 cosh(vec3 x);
vec4 cosh(vec4 x);
float tanh(float x);
vec2 tanh(vec2 x);
vec3 tanh(vec3 x);
vec4 tanh(vec4 x);
float asinh(float x);
vec2 asinh(vec2 x);
vec3 asinh(vec3 x);
vec4 asinh(vec4 x);
float acosh(float x);
vec2 acosh(vec2 x);
vec3 acosh(vec3 x);
vec4 acosh(vec4 x);
float atanh(float x);
vec2 atanh(vec2 x);
vec3 atanh(vec3 x);
vec4 atanh(vec4 x);

// Exponential functions.
float pow(float x, float y);
vec2 pow(vec2 x, vec2 y);
vec3 pow(vec3 x, vec3 y);
vec4 pow(vec4 x, vec4 y);
float exp(float x);
vec2 exp(vec2 x);
vec3 exp(vec3 x);
vec4 exp(vec4 x);
float log(float x);
vec2 log(vec2 x);
vec3 log(vec3 x);
vec4 log(vec4 x);
float exp2(float x);
vec2 exp2(vec2 x);
vec3 exp2(vec3 x);
vec4 exp2(vec4 x);
float log2(float x);
vec2 log2(vec2 x);
vec3 log2(vec3 x);
vec4 log2(vec4 x);
float sqrt(float x);
vec2 sqrt(vec2 x);
vec3 sqrt(vec3 x);
vec4 sqrt(vec4 x);
double sqrt(double x);
dvec2 sqrt(dvec2 x);
dvec3 sqrt(dvec3 x);
dvec4 sqrt(dvec4 x);
float inversesqrt(float x);
vec2 inversesqrt(vec2 x);
vec3 inversesqrt(vec3 x);
vec4 inversesqrt(vec4 x);
double inversesqrt(double x);
dvec2 inversesqrt(dvec2 x);
dvec3 inversesqrt(dvec3 x);
dvec4 inversesqrt(dvec4 x);

// Common functions.
float abs(float x);
vec2 abs(vec2 x);
vec3 abs(vec3 x);
vec4 abs(vec4 x);
int abs(int x);
ivec2 abs(ivec2 x);
ivec3 abs(ivec3 x);
ivec4 abs(ivec4 x);
double abs(double x);
dvec2 abs(dvec2 x);
dvec3 abs(dvec3 x);
dvec4 abs(dvec4 x);
float sign(float x);
vec2 sign(vec2 x);
vec3 sign(vec3 x);
vec4 sign(vec4 x);
int sign(int x);
ivec2 sign(ivec2 x);
ivec3 sign(ivec3 x);
ivec4 sign(ivec4 x);
double sign(double x);
dvec2 sign(dvec2 x);
dvec3 sign(dvec3 x);
dvec4 sign(dvec4 x);
float floor(float x);
vec2 floor(vec2 x);
vec3 floor(vec3 x);
vec4 floor(vec4 x);
double floor(double x);
dvec2 floor(dvec2 x);
dvec3 floor(dvec3 x);
dvec4 floor(dvec4 x);
float trunc(float x);
vec2 trunc(vec2 x);
vec3 trunc(vec3 x);
vec4 trunc(vec4 x);
double trunc(double x);
dvec2 trunc(dvec2 x);
dvec3 trunc(dvec3 x);
dvec4 trunc(dvec4 x);
float round(float x);
vec2 round(vec2 x);
vec3 round(vec3 x);
vec4 round(vec4 x);
double round(double x);
dvec2 round(dvec2 x);
dvec3 round(dvec3 x);
dvec4 round(dvec4 x);
float roundEven(float x);
vec2 roundEven(vec2 x);
vec3 roundEven(vec3 x);
vec4 roundEven(vec4 x);
double roundEven(double x);
dvec2 roundEven(dvec2 x);
dvec3 roundEven(dvec3 x);
dvec4 roundEven(dvec4 x);
float ceil(float x);
vec2 ceil(vec2 x);
vec3 ceil(vec3 x);
vec4 ceil(vec4 x);
double ceil(double x);
dvec2 ceil(dvec2 x);
dvec3 ceil(dvec3 x);
dvec4 ceil(dvec4 x);
float fract(float x);
vec2 fract(vec2 x);
vec3 fract(vec3 x);
vec4 fract(vec4 x);
double fract(double x);
dvec2 fract(dvec2 x);
dvec3 fract(dvec3 x);
dvec4 fract(dvec4 x);
float mod(float x, float y);
vec2 mod(vec2 x, float y);
vec3 mod(vec3 x, float y);
vec4 mod(vec4 x, float y);
vec2 mod(vec2 x, vec2 y);
vec3 mod(vec3 x, vec3 y);
vec4 mod(vec4 x, vec4 y);
double mod(double x, double y);
dvec2 mod(dvec2 x, double y);
dvec3 mod(dvec3 x, double y);
dvec4 mod(dvec4 x, double y);
dvec2 mod(dvec2 x, dvec2 y);
dvec3 mod(dvec3 x, dvec3 y);
dvec4 mod(dvec4 x, dvec4 y);
float modf(float x, float y);
vec2 modf(vec2 x, vec2 y);
vec3 modf(vec3 x, vec3 y);
vec4 modf(vec4 x, vec4 y);
double modf(double x, double y);
dvec2 modf(dvec2 x, dvec2 y);
dvec3 modf(dvec3 x, dvec3 y);
dvec4 modf(dvec4 x, dvec4 y);
float min(float x, float y);
vec2 min(vec2 x, vec2 y);
vec3 min(vec3 x, vec3 y);
vec4 min(vec4 x, vec4 y);
vec2 min(vec2 x, float y);
vec3 min(vec3 x, float y);
vec4 min(vec4 x, float y);
double min(double x, double y);
dvec2 min(dvec2 x, dvec2 y);
dvec3 min(dvec3 x, dvec3 y);
dvec4 min(dvec4 x, dvec4 y);
dvec2 min(dvec2 x, double y);
dvec3 min(dvec3 x, double y);
dvec4 min(dvec4 x, double y);
int min(int x, int y);
ivec2 min(ivec2 x, ivec2 y);
ivec3 min(ivec3 x, ivec3 y);
ivec4 min(ivec4 x, ivec4 y);
ivec2 min(ivec2 x, int y);
ivec3 min(ivec3 x, int y);
ivec4 min(ivec4 x, int y);
uint min(uint x, uint y);
uvec2 min(uvec2 x, uvec2 y);
uvec3 min(uvec3 x, uvec3 y);
uvec4 min(uvec4 x, uvec4 y);
uvec2 min(uvec2 x, uint y);
uvec3 min(uvec3 x, uint y);
uvec4 min(uvec4 x, uint y);
float max(float x, float y);
vec2 max(vec2 x, vec2 y);
vec3 max(vec3 x, vec3 y);
vec4 max(vec4 x, vec4 y);
vec2 max(vec2 x, float y);
vec3 max(vec3 x, float y);
vec4 max(vec4 x, float y);
double max(double x, double y);
dvec2 max(dvec2 x, dvec2 y);
dvec3 max(dvec3 x, dvec3 y);
dvec4 max(dvec4 x, dvec4 y);
dvec2 max(dvec2 x, double y);
dvec3 max(dvec3 x, double y);
dvec4 max(dvec4 x, double y);
int max(int x, int y);
ivec2 max(ivec2 x, ivec2 y);
ivec3 max(ivec3 x, ivec3 y);
ivec4 max(ivec4 x, ivec4 y);
ivec2 max(ivec2 x, int y);
ivec3 max(ivec3 x, int y);
ivec4 max(ivec4 x, int y);
uint max(uint x, uint y);
uvec2 max(uvec2 x, uvec2 y);
uvec3 max(uvec3 x, uvec3 y);
uvec4 max(uvec4 x, uvec4 y);
uvec2 max(uvec2 x, uint y);
uvec3 max(uvec3 x, uint y);
uvec4 max(uvec4 x, uint y);
float clamp(float x, float min, float max);
vec2 clamp(vec2 x, vec2 min, vec2 max);
vec3 clamp(vec3 x, vec3 min, vec3 max);
vec4 clamp(vec4 x, vec4 min, vec4 max);
vec2 clamp(vec2 x, vec2 min, float max);
vec3 clamp(vec3 x, vec3 min, float max);
vec4 clamp(vec4 x, vec4 min, float max);
double clamp(double x, double min, double max);
dvec2 clamp(dvec2 x, dvec2 min, dvec2 max);
dvec3 clamp(dvec3 x, dvec3 min, dvec3 max);
dvec4 clamp(dvec4 x, dvec4 min, dvec4 max);
dvec2 clamp(dvec2 x, dvec2 min, double max);
dvec3 clamp(dvec3 x, dvec3 min, double max);
dvec4 clamp(dvec4 x, dvec4 min, double max);
int clamp(int x, int min, int max);
ivec2 clamp(ivec2 x, ivec2 min, ivec2 max);
ivec3 clamp(ivec3 x, ivec3 min, ivec3 max);
ivec4 clamp(ivec4 x, ivec4 min, ivec4 max);
ivec2 clamp(ivec2 x, ivec2 min, int max);
ivec3 clamp(ivec3 x, ivec3 min, int max);
ivec4 clamp(ivec4 x, ivec4 min, int max);
uint clamp(uint x, uint min, uint max);
uvec2 clamp(uvec2 x, uvec2 min, uvec2 max);
uvec3 clamp(uvec3 x, uvec3 min, uvec3 max);
uvec4 clamp(uvec4 x, uvec4 min, uvec4 max);
uvec2 clamp(uvec2 x, uvec2 min, uint max);
uvec3 clamp(uvec3 x, uvec3 min, uint max);
uvec4 clamp(uvec4 x, uvec4 min, uint max);
float mix(float x, float y, float a);
vec2 mix(vec2 x, vec2 y, vec2 a);
vec3 mix(vec3 x, vec3 y, vec3 a);
vec4 mix(vec4 x, vec4 y, vec4 a);
vec2 mix(vec2 x, vec2 y, float a);
vec3 mix(vec3 x, vec3 y, float a);
vec4 mix(vec4 x, vec4 y, float a);
float mix(float x, float y, bool a);
vec2 mix(vec2 x, vec2 y, bool a);
vec3 mix(vec3 x, vec3 y, bool a);
vec4 mix(vec4 x, vec4 y, bool a);
float mix(float x, float y, bvec2 a);
vec2 mix(vec2 x, vec2 y, bvec2 a);
vec3 mix(vec3 x, vec3 y, bvec2 a);
vec4 mix(vec4 x, vec4 y, bvec2 a);
float mix(float x, float y, bvec3 a);
vec2 mix(vec2 x, vec2 y, bvec3 a);
vec3 mix(vec3 x, vec3 y, bvec3 a);
vec4 mix(vec4 x, vec4 y, bvec3 a);
float mix(float x, float y, bvec4 a);
vec2 mix(vec2 x, vec2 y, bvec4 a);
vec3 mix(vec3 x, vec3 y, bvec4 a);
vec4 mix(vec4 x, vec4 y, bvec4 a);
double mix(double x, double y, double a);
dvec2 mix(dvec2 x, dvec2 y, vec2 a);
dvec3 mix(dvec3 x, dvec3 y, vec3 a);
dvec4 mix(dvec4 x, dvec4 y, vec4 a);
dvec2 mix(dvec2 x, dvec2 y, double a);
dvec3 mix(dvec3 x, dvec3 y, double a);
dvec4 mix(dvec4 x, dvec4 y, double a);
double mix(double x, double y, bool a);
dvec2 mix(dvec2 x, dvec2 y, bool a);
dvec3 mix(dvec3 x, dvec3 y, bool a);
dvec4 mix(dvec4 x, dvec4 y, bool a);
double mix(double x, double y, bvec2 a);
dvec2 mix(dvec2 x, dvec2 y, bvec2 a);
dvec3 mix(dvec3 x, dvec3 y, bvec2 a);
dvec4 mix(dvec4 x, dvec4 y, bvec2 a);
double mix(double x, double y, bvec3 a);
dvec2 mix(dvec2 x, dvec2 y, bvec3 a);
dvec3 mix(dvec3 x, dvec3 y, bvec3 a);
dvec4 mix(dvec4 x, dvec4 y, bvec3 a);
double mix(double x, double y, bvec4 a);
dvec2 mix(dvec2 x, dvec2 y, bvec4 a);
dvec3 mix(dvec3 x, dvec3 y, bvec4 a);
dvec4 mix(dvec4 x, dvec4 y, bvec4 a);
float step(float edge, float x);
vec2 step(vec2 edge, vec2 x);
vec3 step(vec3 edge, vec3 x);
vec4 step(vec4 edge, vec4 x);
vec2 step(float edge, vec2 x);
vec3 step(float edge, vec3 x);
vec4 step(float edge, vec4 x);
double step(double edge, double x);
dvec2 step(dvec2 edge, dvec2 x);
dvec3 step(dvec3 edge, dvec3 x);
dvec4 step(dvec4 edge, dvec4 x);
dvec2 step(double edge, dvec2 x);
dvec3 step(double edge, dvec3 x);
dvec4 step(double edge, dvec4 x);
float smoothstep(float edge0, float edge1, float x);
vec2 smoothstep(vec2 edge0, vec2 edge1, vec2 x);
vec3 smoothstep(vec3 edge0, vec3 edge1, vec3 x);
vec4 smoothstep(vec4 edge0, vec4 edge1, vec4 x);
vec2 smoothstep(float edge0, float edge1, vec2 x);
vec3 smoothstep(float edge0, float edge1, vec3 x);
vec4 smoothstep(float edge0, float edge1, vec4 x);
float smoothstep(double edge0, double edge1, double x);
dvec2 smoothstep(dvec2 edge0, dvec2 edge1, dvec2 x);
dvec3 smoothstep(dvec3 edge0, dvec3 edge1, dvec3 x);
dvec4 smoothstep(dvec4 edge0, dvec4 edge1, dvec4 x);
dvec2 smoothstep(double edge0, double edge1, dvec2 x);
dvec3 smoothstep(double edge0, double edge1, dvec3 x);
dvec4 smoothstep(double edge0, double edge1, dvec4 x);
bool isnan(float x);
bvec2 isnan(vec2 x);
bvec3 isnan(vec3 x);
bvec4 isnan(vec4 x);
bool isnan(double x);
bvec2 isnan(dvec2 x);
bvec3 isnan(dvec3 x);
bvec4 isnan(dvec4 x);
bool isinf(float x);
bvec2 isinf(vec2 x);
bvec3 isinf(vec3 x);
bvec4 isinf(vec4 x);
bool isinf(double x);
bvec2 isinf(dvec2 x);
bvec3 isinf(dvec3 x);
bvec4 isinf(dvec4 x);
int floatBitsToInt(highp float x);
ivec2 floatBitsToInt(highp vec2 x);
ivec3 floatBitsToInt(highp vec3 x);
ivec4 floatBitsToInt(highp vec4 x);
uint floatBitsToUint(highp float x);
uvec2 floatBitsToUint(highp vec2 x);
uvec3 floatBitsToUint(highp vec3 x);
uvec4 floatBitsToUint(highp vec4 x);
float intBitsToFloat(highp int x);
vec2 intBitsToFloat(highp ivec2 x);
vec3 intBitsToFloat(highp ivec3 x);
vec4 intBitsToFloat(highp ivec4 x);
float uintBitsToFloat(highp uint x);
vec2 uintBitsToFloat(highp uvec2 x);
vec3 uintBitsToFloat(highp uvec3 x);
vec4 uintBitsToFloat(highp uvec4 x);
float fma(float a, float b, float c);
vec2 fma(vec2 a, vec2 b, vec2 d);
vec3 fma(vec3 a, vec3 b, vec3 d);
vec4 fma(vec4 a, vec4 b, vec4 d);
double fma(double a, double b, double c);
dvec2 fma(dvec2 a, dvec2 b, dvec2 d);
dvec3 fma(dvec3 a, dvec3 b, dvec3 d);
dvec4 fma(dvec4 a, dvec4 b, dvec4 d);
float frexp(highp float x, out highp int exp);
vec2 frexp(highp vec2 x, out highp ivec2 exp);
vec3 frexp(highp vec3 x, out highp ivec3 exp);
vec4 frexp(highp vec4 x, out highp ivec4 exp);
double frexp(highp double x, out highp int exp);
dvec2 frexp(highp dvec2 x, out highp ivec2 exp);
dvec3 frexp(highp dvec3 x, out highp ivec3 exp);
dvec4 frexp(highp dvec4 x, out highp ivec4 exp);
float ldexp(highp float x, highp int exp);
vec2 ldexp(highp vec2 x, highp ivec2 exp);
vec3 ldexp(highp vec3 x, highp ivec3 exp);
vec4 ldexp(highp vec4 x, highp ivec4 exp);
double ldexp(highp double x, highp int exp);
dvec2 ldexp(highp dvec2 x, highp ivec2 exp);
dvec3 ldexp(highp dvec3 x, highp ivec3 exp);
dvec4 ldexp(highp dvec4 x, highp ivec4 exp);

// Floating-point pack and unpack functions.
highp uint packUnorm2x16(vec2 v);
highp uint packSnorm2x16(vec2 v);
uint packUnorm4x8(vec4 v);
uint packSnorm4x8(vec4 v);
vec2 unpackUnorm2x16(highp uint p);
vec2 unpackSnorm2x16(highp uint p);
vec4 unpackUnorm4x8(highp uint p);
vec4 unpackSnorm4x8(highp uint p);
uint packHalf2x16(vec2 v);
vec2 unpackHalf2x16(uint v);
double packDouble2x32(uvec2 v);
uvec2 unpackDouble2x32(double v);

// Geometric functions.
float length(float x);
float length(vec2 x);
float length(vec3 x);
float length(vec4 x);
double length(double x);
double length(dvec2 x);
double length(dvec3 x);
double length(dvec4 x);
float distance(float x, float y);
float distance(vec2 x, vec2 y);
float distance(vec3 x, vec3 y);
float distance(vec4 x, vec4 y);
double distance(double x, double y);
double distance(dvec2 x, dvec2 y);
double distance(dvec3 x, dvec3 y);
double distance(dvec4 x, dvec4 y);
float dot(float x, float y);
float dot(vec2 x, vec2 y);
float dot(vec3 x, vec3 y);
float dot(vec4 x, vec4 y);
double dot(double x, double y);
double dot(dvec2 x, dvec2 y);
double dot(dvec3 x, dvec3 y);
double dot(dvec4 x, dvec4 y);
vec3 cross(vec3 x, vec3 y);
dvec3 cross(dvec3 x, dvec3 y);
float normalize(float x);
vec2 normalize(vec2 x);
vec3 normalize(vec3 x);
vec4 normalize(vec4 x);
double normalize(double x);
dvec2 normalize(dvec2 x);
dvec3 normalize(dvec3 x);
dvec4 normalize(dvec4 x);

// Compatibility profile only.
vec4 ftransform();
float faceforward(float n, float i, float nref);
vec2 faceforward(vec2 n, vec2 i, vec2 nref);
vec3 faceforward(vec3 n, vec3 i, vec3 nref);
vec4 faceforward(vec4 n, vec4 i, vec4 nref);
double faceforward(double n, double i, double nref);
dvec2 faceforward(dvec2 n, dvec2 i, dvec2 nref);
dvec3 faceforward(dvec3 n, dvec3 i, dvec3 nref);
dvec4 faceforward(dvec4 n, dvec4 i, dvec4 nref);
float reflect(float n, float i);
vec2 reflect(vec2 n, vec2 i);
vec3 reflect(vec3 n, vec3 i);
vec4 reflect(vec4 n, vec4 i);
double reflect(double n, double i);
dvec2 reflect(dvec2 n, dvec2 i);
dvec3 reflect(dvec3 n, dvec3 i);
dvec4 reflect(dvec4 n, dvec4 i);
float refract(float n, float i, float eta);
vec2 refract(vec2 n, vec2 i, float eta);
vec3 refract(vec3 n, vec3 i, float eta);
vec4 refract(vec4 n, vec4 i, float eta);
double refract(double n, double i, double eta);
dvec2 refract(dvec2 n, dvec2 i, double eta);
dvec3 refract(dvec3 n, dvec3 i, double eta);
dvec4 refract(dvec4 n, dvec4 i, double eta);

// Matrix functions.
mat2 matrixCompMult(mat2 x, mat2 y);
mat3 matrixCompMult(mat3 x, mat3 y);
mat4 matrixCompMult(mat4 x, mat4 y);
mat2x4 matrixCompMult(mat2x4 x, mat2x4 y);
mat4x2 matrixCompMult(mat4x2 x, mat4x2 y);
mat2x3 matrixCompMult(mat2x3 x, mat2x3 y);
mat3x2 matrixCompMult(mat3x2 x, mat3x2 y);
mat3x4 matrixCompMult(mat3x4 x, mat3x4 y);
mat4x3 matrixCompMult(mat4x3 x, mat4x3 y);
mat4x4 matrixCompMult(mat4x4 x, mat4x4 y);
dmat2 matrixCompMult(dmat2 x, dmat2 y);
dmat3 matrixCompMult(dmat3 x, dmat3 y);
dmat4 matrixCompMult(dmat4 x, dmat4 y);
dmat2x4 matrixCompMult(dmat2x4 x, dmat2x4 y);
dmat4x2 matrixCompMult(dmat4x2 x, dmat4x2 y);
dmat2x3 matrixCompMult(dmat2x3 x, dmat2x3 y);
dmat3x2 matrixCompMult(dmat3x2 x, dmat3x2 y);
dmat3x4 matrixCompMult(dmat3x4 x, dmat3x4 y);
dmat4x3 matrixCompMult(dmat4x3 x, dmat4x3 y);
dmat4x4 matrixCompMult(dmat4x4 x, dmat4x4 y);
mat2 outerProduct(vec2 c, vec2 r);
mat3 outerProduct(vec3 c, vec3 r);
mat4 outerProduct(vec4 c, vec4 r);
mat2x3 outerProduct(vec3 c, vec2 r);
mat3x2 outerProduct(vec2 c, vec3 r);
mat2x4 outerProduct(vec4 c, vec2 r);
mat4x2 outerProduct(vec2 c, vec4 r);
mat3x4 outerProduct(vec4 c, vec3 r);
mat4x3 outerProduct(vec3 c, vec4 r);
dmat2 outerProduct(dvec2 c, dvec2 r);
dmat3 outerProduct(dvec3 c, dvec3 r);
dmat4 outerProduct(dvec4 c, dvec4 r);
dmat2x3 outerProduct(dvec3 c, dvec2 r);
dmat3x2 outerProduct(dvec2 c, dvec3 r);
dmat2x4 outerProduct(dvec4 c, dvec2 r);
dmat4x2 outerProduct(dvec2 c, dvec4 r);
dmat3x4 outerProduct(dvec4 c, dvec3 r);
dmat4x3 outerProduct(dvec3 c, dvec4 r);
mat2 transpose(mat2 m);
mat3 transpose(mat3 m);
mat4 transpose(mat4 m);
mat2x3 transpose(mat3x2 m);
mat3x2 transpose(mat2x3 m);
mat2x4 transpose(mat4x2 m);
mat4x2 transpose(mat2x4 m);
mat3x4 transpose(mat4x3 m);
mat4x3 transpose(mat3x4 m);
dmat2 transpose(dmat2 m);
dmat3 transpose(dmat3 m);
dmat4 transpose(dmat4 m);
dmat2x3 transpose(dmat3x2 m);
dmat3x2 transpose(dmat2x3 m);
dmat2x4 transpose(dmat4x2 m);
dmat4x2 transpose(dmat2x4 m);
dmat3x4 transpose(dmat4x3 m);
dmat4x3 transpose(dmat3x4 m);
float determinant(mat2 m);
float determinant(mat3 m);
float determinant(mat4 m);
mat2 inverse(mat2 m);
mat3 inverse(mat3 m);
mat4 inverse(mat4 m);

// Vector relational functions.
bvec2 lessThan(vec2 x, vec2 y);
bvec3 lessThan(vec3 x, vec3 y);
bvec4 lessThan(vec4 x, vec4 y);
bvec2 lessThan(dvec2 x, dvec2 y);
bvec3 lessThan(dvec3 x, dvec3 y);
bvec4 lessThan(dvec4 x, dvec4 y);
bvec2 lessThan(ivec2 x, ivec2 y);
bvec3 lessThan(ivec3 x, ivec3 y);
bvec4 lessThan(ivec4 x, ivec4 y);
bvec2 lessThan(uvec2 x, uvec2 y);
bvec3 lessThan(uvec3 x, uvec3 y);
bvec4 lessThan(uvec4 x, uvec4 y);
bvec2 lessThanEqual(vec2 x, vec2 y);
bvec3 lessThanEqual(vec3 x, vec3 y);
bvec4 lessThanEqual(vec4 x, vec4 y);
bvec2 lessThanEqual(dvec2 x, dvec2 y);
bvec3 lessThanEqual(dvec3 x, dvec3 y);
bvec4 lessThanEqual(dvec4 x, dvec4 y);
bvec2 lessThanEqual(ivec2 x, ivec2 y);
bvec3 lessThanEqual(ivec3 x, ivec3 y);
bvec4 lessThanEqual(ivec4 x, ivec4 y);
bvec2 lessThanEqual(uvec2 x, uvec2 y);
bvec3 lessThanEqual(uvec3 x, uvec3 y);
bvec4 lessThanEqual(uvec4 x, uvec4 y);
bvec2 greaterThan(vec2 x, vec2 y);
bvec3 greaterThan(vec3 x, vec3 y);
bvec4 greaterThan(vec4 x, vec4 y);
bvec2 greaterThan(dvec2 x, dvec2 y);
bvec3 greaterThan(dvec3 x, dvec3 y);
bvec4 greaterThan(dvec4 x, dvec4 y);
bvec2 greaterThan(ivec2 x, ivec2 y);
bvec3 greaterThan(ivec3 x, ivec3 y);
bvec4 greaterThan(ivec4 x, ivec4 y);
bvec2 greaterThan(uvec2 x, uvec2 y);
bvec3 greaterThan(uvec3 x, uvec3 y);
bvec4 greaterThan(uvec4 x, uvec4 y);
bvec2 greaterThanEqual(vec2 x, vec2 y);
bvec3 greaterThanEqual(vec3 x, vec3 y);
bvec4 greaterThanEqual(vec4 x, vec4 y);
bvec2 greaterThanEqual(dvec2 x, dvec2 y);
bvec3 greaterThanEqual(dvec3 x, dvec3 y);
bvec4 greaterThanEqual(dvec4 x, dvec4 y);
bvec2 greaterThanEqual(ivec2 x, ivec2 y);
bvec3 greaterThanEqual(ivec3 x, ivec3 y);
bvec4 greaterThanEqual(ivec4 x, ivec4 y);
bvec2 greaterThanEqual(uvec2 x, uvec2 y);
bvec3 greaterThanEqual(uvec3 x, uvec3 y);
bvec4 greaterThanEqual(uvec4 x, uvec4 y);
bvec2 equal(vec2 x, vec2 y);
bvec3 equal(vec3 x, vec3 y);
bvec4 equal(vec4 x, vec4 y);
bvec2 equal(dvec2 x, dvec2 y);
bvec3 equal(dvec3 x, dvec3 y);
bvec4 equal(dvec4 x, dvec4 y);
bvec2 equal(ivec2 x, ivec2 y);
bvec3 equal(ivec3 x, ivec3 y);
bvec4 equal(ivec4 x, ivec4 y);
bvec2 equal(uvec2 x, uvec2 y);
bvec3 equal(uvec3 x, uvec3 y);
bvec4 equal(uvec4 x, uvec4 y);
bvec2 equal(bvec2 x, bvec2 y);
bvec3 equal(bvec3 x, bvec3 y);
bvec4 equal(bvec4 x, bvec4 y);
bvec2 notEqual(vec2 x, vec2 y);
bvec3 notEqual(vec3 x, vec3 y);
bvec4 notEqual(vec4 x, vec4 y);
bvec2 notEqual(dvec2 x, dvec2 y);
bvec3 notEqual(dvec3 x, dvec3 y);
bvec4 notEqual(dvec4 x, dvec4 y);
bvec2 notEqual(ivec2 x, ivec2 y);
bvec3 notEqual(ivec3 x, ivec3 y);
bvec4 notEqual(ivec4 x, ivec4 y);
bvec2 notEqual(uvec2 x, uvec2 y);
bvec3 notEqual(uvec3 x, uvec3 y);
bvec4 notEqual(uvec4 x, uvec4 y);
bvec2 notEqual(bvec2 x, bvec2 y);
bvec3 notEqual(bvec3 x, bvec3 y);
bvec4 notEqual(bvec4 x, bvec4 y);
bool any(bvec2 b);
bool any(bvec3 b);
bool any(bvec4 b);
bool all(bvec2 b);
bool all(bvec3 b);
bool all(bvec4 b);
bvec2 not(bvec2 x);
bvec3 not(bvec3 x);
bvec4 not(bvec4 x);

// Integer functions.
uint uaddCarry(highp uint x, highp uint y, out lowp uint carry);
uvec2 uaddCarry(highp uvec2 x, highp uvec2 y, out lowp uvec2 carry);
uvec3 uaddCarry(highp uvec3 x, highp uvec3 y, out lowp uvec3 carry);
uvec4 uaddCarry(highp uvec4 x, highp uvec4 y, out lowp uvec4 carry);
uint usubBorrow(highp uint x, highp uint y, out lowp uint borrow);
uvec2 usubBorrow(highp uvec2 x, highp uvec2 y, out lowp uvec2 borrow);
uvec3 usubBorrow(highp uvec3 x, highp uvec3 y, out lowp uvec3 borrow);
uvec4 usubBorrow(highp uvec4 x, highp uvec4 y, out lowp uvec4 borrow);
void umulExtended(highp uint x, highp uint y, out highp uint msb, out highp uint lsb);
void umulExtended(highp uvec2 x, highp uvec2 y, out highp uvec2 msb, out highp uvec2 lsb);
void umulExtended(highp uvec3 x, highp uvec3 y, out highp uvec3 msb, out highp uvec3 lsb);
void umulExtended(highp uvec4 x, highp uvec4 y, out highp uvec4 msb, out highp uvec4 lsb);
void imulExtended(highp int x, highp int y, out highp int msb, out highp int lsb);
void imulExtended(highp ivec2 x, highp ivec2 y, out highp ivec2 msb, out highp ivec2 lsb);
void imulExtended(highp ivec3 x, highp ivec3 y, out highp ivec3 msb, out highp ivec3 lsb);
void imulExtended(highp ivec4 x, highp ivec4 y, out highp ivec4 msb, out highp ivec4 lsb);
int bitfieldExtract(int value, int offset, int bits);
vec2 bitfieldExtract(vec2 value, vec2 offset, vec2 bits);
vec3 bitfieldExtract(vec3 value, vec3 offset, vec3 bits);
vec4 bitfieldExtract(vec4 value, vec4 offset, vec4 bits);
uint bitfieldExtract(uint value, uint offset, uint bits);
uvec2 bitfieldExtract(uvec2 value, uvec2 offset, uvec2 bits);
uvec3 bitfieldExtract(uvec3 value, uvec3 offset, uvec3 bits);
uvec4 bitfieldExtract(uvec4 value, uvec4 offset, uvec4 bits);
int bitfieldInsert(int base, int insert, int offseet, int bits);
vec2 bitfieldInsert(vec2 base, vec2 insert, vec2 offseet, vec2 bits);
vec3 bitfieldInsert(vec3 base, vec3 insert, vec3 offseet, vec3 bits);
vec4 bitfieldInsert(vec4 base, vec4 insert, vec4 offseet, vec4 bits);
uint bitfieldInsert(uint base, uint insert, uint offseet, uint bits);
uvec2 bitfieldInsert(uvec2 base, uvec2 insert, uvec2 offseet, uvec2 bits);
uvec3 bitfieldInsert(uvec3 base, uvec3 insert, uvec3 offseet, uvec3 bits);
uvec4 bitfieldInsert(uvec4 base, uvec4 insert, uvec4 offseet, uvec4 bits);
int bitfieldReverse(highp int value);
vec2 bitfieldReverse(highp vec2 value);
vec3 bitfieldReverse(highp vec3 value);
vec4 bitfieldReverse(highp vec4 value);
uint bitfieldReverse(highp uint value);
uvec2 bitfieldReverse(highp uvec2 value);
uvec3 bitfieldReverse(highp uvec3 value);
uvec4 bitfieldReverse(highp uvec4 value);
int bitCount(int value);
vec2 bitCount(vec2 value);
vec3 bitCount(vec3 value);
vec4 bitCount(vec4 value);
int bitCount(uint value);
vec2 bitCount(uvec2 value);
vec3 bitCount(uvec3 value);
vec4 bitCount(uvec4 value);
int findLSB(int value);
vec2 findLSB(vec2 value);
vec3 findLSB(vec3 value);
vec4 findLSB(vec4 value);
int findLSB(uint value);
vec2 findLSB(uvec2 value);
vec3 findLSB(uvec3 value);
vec4 findLSB(uvec4 value);
int findMSB(highp int value);
vec2 findMSB(highp vec2 value);
vec3 findMSB(highp vec3 value);
vec4 findMSB(highp vec4 value);
int findMSB(highp uint value);
vec2 findMSB(highp uvec2 value);
vec3 findMSB(highp uvec3 value);
vec4 findMSB(highp uvec4 value);

// Texture lookup functions.
int textureSize(sampler1D _sampler, int lod);
int textureSize(isampler1D _sampler, int lod);
int textureSize(usampler1D _sampler, int lod);
ivec2 textureSize(sampler2D _sampler, int lod);
ivec2 textureSize(isampler2D _sampler, int lod);
ivec2 textureSize(usampler2D _sampler, int lod);
ivec3 textureSize(sampler3D _sampler, int lod);
ivec3 textureSize(isampler3D _sampler, int lod);
ivec3 textureSize(usampler3D _sampler, int lod);
ivec2 textureSize(samplerCube _sampler, int lod);
ivec2 textureSize(isamplerCube _sampler, int lod);
ivec2 textureSize(usamplerCube _sampler, int lod);
int textureSize(sampler1DShadow _sampler, int lod);
ivec2 textureSize(sampler2DShadow _sampler, int lod);
ivec2 textureSize(samplerCubeShadow _sampler, int lod);
ivec2 textureSize(sampler2DRect _sampler);
ivec2 textureSize(isampler2DRect _sampler);
ivec2 textureSize(usampler2DRect _sampler);
ivec2 textureSize(sampler2DRectShadow _sampler);
ivec2 textureSize(sampler1DArray _sampler, int lod);
ivec2 textureSize(isampler1DArray _sampler, int lod);
ivec2 textureSize(usampler1DArray _sampler, int lod);
ivec3 textureSize(sampler2DArray _sampler, int lod);
ivec3 textureSize(isampler2DArray _sampler, int lod);
ivec3 textureSize(usampler2DArray _sampler, int lod);
ivec2 textureSize(sampler1DArrayShadow _sampler, int lod);
ivec3 textureSize(sampler2DArrayShadow _sampler, int lod);
int textureSize(samplerBuffer _sampler);
int textureSize(isamplerBuffer _sampler);
int textureSize(usamplerBuffer _sampler);
ivec2 textureSize(sampler2DMS _sampler);
ivec2 textureSize(isampler2DMS _sampler);
ivec2 textureSize(usampler2DMS _sampler);
ivec2 textureSize(sampler2DMSArray _sampler);
ivec2 textureSize(isampler2DMSArray _sampler);
ivec2 textureSize(usampler2DMSArray _sampler);
vec2 textureQueryLod(sampler1D _sampler, float p);
vec2 textureQueryLod(isampler1D _sampler, float p);
vec2 textureQueryLod(usampler1D _sampler, float p);
vec2 textureQueryLod(sampler2D _sampler, vec2 p);
vec2 textureQueryLod(isampler2D _sampler, vec2 p);
vec2 textureQueryLod(usampler2D _sampler, vec2 p);
vec2 textureQueryLod(sampler3D _sampler, vec3 p);
vec2 textureQueryLod(isampler3D _sampler, vec3 p);
vec2 textureQueryLod(usampler3D _sampler, vec3 p);
vec2 textureQueryLod(samplerCube _sampler, vec3 p);
vec2 textureQueryLod(isamplerCube _sampler, vec3 p);
vec2 textureQueryLod(usamplerCube _sampler, vec3 p);
vec2 textureQueryLod(sampler1DArray _sampler, float p);
vec2 textureQueryLod(isampler1DArray _sampler, float p);
vec2 textureQueryLod(usampler1DArray _sampler, float p);
vec2 textureQueryLod(sampler2DArray _sampler, vec2 p);
vec2 textureQueryLod(isampler2DArray _sampler, vec2 p);
vec2 textureQueryLod(usampler2DArray _sampler, vec2 p);
vec2 textureQueryLod(samplerCubeArray _sampler, vec3 p);
vec2 textureQueryLod(isamplerCubeArray _sampler, vec3 p);
vec2 textureQueryLod(usamplerCubeArray _sampler, vec3 p);
vec2 textureQueryLod(sampler1DShadow _sampler, float p);
vec2 textureQueryLod(sampler2DShadow _sampler, vec2 p);
vec2 textureQueryLod(samplerCubeShadow _sampler, vec3 p);
vec2 textureQueryLod(sampler1DArrayShadow _sampler, float p);
vec2 textureQueryLod(sampler2DArrayShadow _sampler, vec2 p);
vec2 textureQueryLod(samplerCubeArrayShadow _sampler, vec3 p);
int textureQueryLevels(sampler1D _sampler);
int textureQueryLevels(isampler1D _sampler);
int textureQueryLevels(usampler1D _sampler);
int textureQueryLevels(sampler2D _sampler);
int textureQueryLevels(isampler2D _sampler);
int textureQueryLevels(usampler2D _sampler);
int textureQueryLevels(sampler3D _sampler);
int textureQueryLevels(isampler3D _sampler);
int textureQueryLevels(usampler3D _sampler);
int textureQueryLevels(samplerCube _sampler);
int textureQueryLevels(isamplerCube _sampler);
int textureQueryLevels(usamplerCube _sampler);
int textureQueryLevels(sampler1DArray _sampler);
int textureQueryLevels(isampler1DArray _sampler);
int textureQueryLevels(usampler1DArray _sampler);
int textureQueryLevels(sampler2DArray _sampler);
int textureQueryLevels(isampler2DArray _sampler);
int textureQueryLevels(usampler2DArray _sampler);
int textureQueryLevels(samplerCubeArray _sampler);
int textureQueryLevels(isamplerCubeArray _sampler);
int textureQueryLevels(usamplerCubeArray _sampler);
int textureQueryLevels(sampler1DShadow _sampler);
int textureQueryLevels(sampler2DShadow _sampler);
int textureQueryLevels(samplerCubeShadow _sampler);
int textureQueryLevels(sampler1DArrayShadow _sampler);
int textureQueryLevels(sampler2DArrayShadow _sampler);
int textureQueryLevels(samplerCubeArrayShadow _sampler);
int textureSamples(sampler2DMS _sampler);
int textureSamples(isampler2DMS _sampler);
int textureSamples(usampler2DMS _sampler);
int textureSamples(sampler2DMSArray _sampler);
int textureSamples(isampler2DMSArray _sampler);
int textureSamples(usampler2DMSArray _sampler);
vec4 texture(sampler1D _sampler, float P);

// Texel lookup functions.
ivec4 texture(isampler1D _sampler, float P);
uvec4 texture(usampler1D _sampler, float P);
vec4 texture(sampler1D _sampler, float P, float bias);
ivec4 texture(isampler1D _sampler, float P, float bias);
uvec4 texture(usampler1D _sampler, float P, float bias);
vec4 texture(sampler2D _sampler, vec2 P);
ivec4 texture(isampler2D _sampler, vec2 P);
uvec4 texture(usampler2D _sampler, vec2 P);
vec4 texture(sampler2D _sampler, vec2 P, float bias);
ivec4 texture(isampler2D _sampler, vec2 P, float bias);
uvec4 texture(usampler2D _sampler, vec2 P, float bias);
vec4 texture(sampler3D _sampler, vec3 P);
ivec4 texture(isampler3D _sampler, vec3 P);
uvec4 texture(usampler3D _sampler, vec3 P);
vec4 texture(sampler3D _sampler, vec3 P, float bias);
ivec4 texture(isampler3D _sampler, vec3 P, float bias);
uvec4 texture(usampler3D _sampler, vec3 P, float bias);
vec4 texture(samplerCube _sampler, vec3 P);
ivec4 texture(isamplerCube _sampler, vec3 P);
uvec4 texture(usamplerCube _sampler, vec3 P);
vec4 texture(samplerCube _sampler, vec3 P, float bias);
ivec4 texture(isamplerCube _sampler, vec3 P, float bias);
uvec4 texture(usamplerCube _sampler, vec3 P, float bias);
float texture(sampler1DShadow _sampler, vec3 P);
float texture(sampler1DShadow _sampler, vec3 P, float bias);
float texture(sampler2DShadow _sampler, vec3 P);
float texture(sampler2DShadow _sampler, vec3 P, float bias);
float texture(samplerCubeShadow _sampler, vec4 P);
float texture(samplerCubeShadow _sampler, vec4 P, float bias);
vec4 texture(sampler1DArray _sampler, vec2 P);
ivec4 texture(isampler1DArray _sampler, vec2 P);
uvec4 texture(usampler1DArray _sampler, vec2 P);
vec4 texture(sampler1DArray _sampler, vec2 P, float bias);
ivec4 texture(isampler1DArray _sampler, vec2 P, float bias);
uvec4 texture(usampler1DArray _sampler, vec2 P, float bias);
vec4 texture(sampler2DArray _sampler, vec3 P);
ivec4 texture(isampler2DArray _sampler, vec3 P);
uvec4 texture(usampler2DArray _sampler, vec3 P);
vec4 texture(sampler2DArray _sampler, vec3 P, float bias);
ivec4 texture(isampler2DArray _sampler, vec3 P, float bias);
uvec4 texture(usampler2DArray _sampler, vec3 P, float bias);
float texture(sampler1DArrayShadow _sampler, vec3 P);
float texture(sampler1DArrayShadow _sampler, vec3 P, float bias);
float texture(sampler2DArrayShadow _sampler, vec4 P);
vec4 texture(sampler2DRect _sampler, vec2 P);
ivec4 texture(isampler2DRect _sampler, vec2 P);
uvec4 texture(usampler2DRect _sampler, vec2 P);
float texture(sampler2DRectShadow _sampler, vec3 P);
float texture(samplerCubeArrayShadow _sampler, vec4 P, float compare);
vec4 textureProj(sampler1D _sampler, vec2 P);
ivec4 textureProj(isampler1D _sampler, vec2 P);
uvec4 textureProj(usampler1D _sampler, vec2 P);
vec4 textureProj(sampler1D _sampler, vec2 P, float bias);
ivec4 textureProj(isampler1D _sampler, vec2 P, float bias);
uvec4 textureProj(usampler1D _sampler, vec2 P, float bias);
vec4 textureProj(sampler1D _sampler, vec4 P);
ivec4 textureProj(isampler1D _sampler, vec4 P);
uvec4 textureProj(usampler1D _sampler, vec4 P);
vec4 textureProj(sampler1D _sampler, vec4 P, float bias);
ivec4 textureProj(isampler1D _sampler, vec4 P, float bias);
uvec4 textureProj(usampler1D _sampler, vec4 P, float bias);
vec4 textureProj(sampler2D _sampler, vec3 P);
ivec4 textureProj(isampler2D _sampler, vec3 P);
uvec4 textureProj(usampler2D _sampler, vec3 P);
vec4 textureProj(sampler2D _sampler, vec3 P, float bias);
ivec4 textureProj(isampler2D _sampler, vec3 P, float bias);
uvec4 textureProj(usampler2D _sampler, vec3 P, float bias);
vec4 textureProj(sampler2D _sampler, vec4 P);
ivec4 textureProj(isampler2D _sampler, vec4 P);
uvec4 textureProj(usampler2D _sampler, vec4 P);
vec4 textureProj(sampler2D _sampler, vec4 P, float bias);
ivec4 textureProj(isampler2D _sampler, vec4 P, float bias);
uvec4 textureProj(usampler2D _sampler, vec4 P, float bias);
vec4 textureProj(sampler3D _sampler, vec4 P);
ivec4 textureProj(isampler3D _sampler, vec4 P);
uvec4 textureProj(usampler3D _sampler, vec4 P);
vec4 textureProj(sampler3D _sampler, vec4 P, float bias);
ivec4 textureProj(isampler3D _sampler, vec4 P, float bias);
uvec4 textureProj(usampler3D _sampler, vec4 P, float bias);
float textureProj(sampler1DShadow _sampler, vec4 P);
float textureProj(sampler1DShadow _sampler, vec4 P, float bias);
float textureProj(sampler2DShadow _sampler, vec4 P);
float textureProj(sampler2DShadow _sampler, vec4 P, float bias);
vec4 textureProj(sampler2DRect _sampler, vec3 P);
ivec4 textureProj(isampler2DRect _sampler, vec3 P);
uvec4 textureProj(usampler2DRect _sampler, vec3 P);
vec4 textureProj(sampler2DRect _sampler, vec4 P);
ivec4 textureProj(isampler2DRect _sampler, vec4 P);
uvec4 textureProj(usampler2DRect _sampler, vec4 P);
float textureProj(sampler2DRectShadow _sampler, vec4 P);
vec4 textureLod(sampler1D _sampler, float P, float lod);
ivec4 textureLod(isampler1D _sampler, float P, float lod);
uvec4 textureLod(usampler1D _sampler, float P, float lod);
vec4 textureLod(sampler2D _sampler, vec2 P, float lod);
ivec4 textureLod(isampler2D _sampler, vec2 P, float lod);
uvec4 textureLod(usampler2D _sampler, vec2 P, float lod);
vec4 textureLod(sampler3D _sampler, vec3 P, float lod);
ivec4 textureLod(isampler3D _sampler, vec3 P, float lod);
uvec4 textureLod(usampler3D _sampler, vec3 P, float lod);
vec4 textureLod(samplerCube _sampler, vec3 P, float lod);
ivec4 textureLod(isamplerCube _sampler, vec3 P, float lod);
uvec4 textureLod(usamplerCube _sampler, vec3 P, float lod);
float textureLod(sampler1DShadow _sampler, vec3 P, float lod);
float textureLod(sampler2DShadow _sampler, vec3 P, float lod);
vec4 textureLod(sampler1DArray _sampler, vec2 P, float lod);
ivec4 textureLod(isampler1DArray _sampler, vec2 P, float lod);
uvec4 textureLod(usampler1DArray _sampler, vec2 P, float lod);
vec4 textureLod(sampler2DArray _sampler, vec3 P, float lod);
ivec4 textureLod(isampler2DArray _sampler, vec3 P, float lod);
uvec4 textureLod(usampler2DArray _sampler, vec3 P, float lod);
vec4 textureLod(samplerCubeArray _sampler, vec4 P, float lod);
ivec4 textureLod(isamplerCubeArray _sampler, vec4 P, float lod);
uvec4 textureLod(usamplerCubeArray _sampler, vec4 P, float lod);
float textureLod(sampler1DArrayShadow _sampler, vec3 P, float lod);
vec4 textureOffset(sampler1D _sampler, float P, int offset);
ivec4 textureOffset(isampler1D _sampler, float P, int offset);
uvec4 textureOffset(usampler1D _sampler, float P, int offset);
vec4 textureOffset(sampler1D _sampler, float P, int offset, float bias);
ivec4 textureOffset(isampler1D _sampler, float P, int offset, float bias);
uvec4 textureOffset(usampler1D _sampler, float P, int offset, float bias);
vec4 textureOffset(sampler2D _sampler, vec2 P, ivec2 offset);
ivec4 textureOffset(isampler2D _sampler, vec2 P, ivec2 offset);
uvec4 textureOffset(usampler2D _sampler, vec2 P, ivec2 offset);
vec4 textureOffset(sampler2D _sampler, vec2 P, ivec2 offset, float bias);
ivec4 textureOffset(isampler2D _sampler, vec2 P, ivec2 offset, float bias);
uvec4 textureOffset(usampler2D _sampler, vec2 P, ivec2 offset, float bias);
vec4 textureOffset(sampler3D _sampler, vec3 P, ivec3 offset);
ivec4 textureOffset(isampler3D _sampler, vec3 P, ivec3 offset);
uvec4 textureOffset(usampler3D _sampler, vec3 P, ivec3 offset);
vec4 textureOffset(sampler3D _sampler, vec3 P, ivec3 offset, float bias);
ivec4 textureOffset(isampler3D _sampler, vec3 P, ivec3 offset, float bias);
uvec4 textureOffset(usampler3D _sampler, vec3 P, ivec3 offset, float bias);
vec4 textureOffset(sampler2DRect _sampler, vec2 P, ivec2 offset);
ivec4 textureOffset(isampler2DRect _sampler, vec2 P, ivec2 offset);
uvec4 textureOffset(usampler2DRect _sampler, vec2 P, ivec2 offset);
float textureOffset(sampler2DRectShadow _sampler, vec3 P, ivec2 offset);
float textureOffset(sampler1DShadow _sampler, vec3 P, int offset);
float textureOffset(sampler1DShadow _sampler, vec3 P, int offset, float bias);
float textureOffset(sampler2DShadow _sampler, vec3 P, ivec2 offset);
float textureOffset(sampler2DShadow _sampler, vec3 P, ivec2 offset, float bias);
vec4 textureOffset(sampler1DArray _sampler, vec2 P, int offset);
ivec4 textureOffset(isampler1DArray _sampler, vec2 P, int offset);
uvec4 textureOffset(usampler1DArray _sampler, vec2 P, int offset);
vec4 textureOffset(sampler1DArray _sampler, vec2 P, int offset, float bias);
ivec4 textureOffset(isampler1DArray _sampler, vec2 P, int offset, float bias);
uvec4 textureOffset(usampler1DArray _sampler, vec2 P, int offset, float bias);
vec4 textureOffset(sampler2DArray _sampler, vec3 P, ivec2 offset);
ivec4 textureOffset(isampler2DArray _sampler, vec3 P, ivec2 offset);
uvec4 textureOffset(usampler2DArray _sampler, vec3 P, ivec2 offset);
vec4 textureOffset(sampler2DArray _sampler, vec3 P, ivec2 offset, float bias);
ivec4 textureOffset(isampler2DArray _sampler, vec3 P, ivec2 offset, float bias);
uvec4 textureOffset(usampler2DArray _sampler, vec3 P, ivec2 offset, float bias);
float textureOffset(sampler1DArrayShadow _sampler, vec3 P, int offset);
float textureOffset(sampler1DArrayShadow _sampler, vec3 P, int offset, float bias);
float textureOffset(sampler2DArrayShadow _sampler, vec4 P, ivec2 offset);
vec4 texelFetch(sampler1D _sampler, int P, int lod);
ivec4 texelFetch(isampler1D _sampler, int P, int lod);
uvec4 texelFetch(usampler1D _sampler, int P, int lod);
vec4 texelFetch(sampler2D _sampler, ivec2 P, int lod);
ivec4 texelFetch(isampler2D _sampler, ivec2 P, int lod);
uvec4 texelFetch(usampler2D _sampler, ivec2 P, int lod);
vec4 texelFetch(sampler3D _sampler, ivec3 P, int lod);
ivec4 texelFetch(isampler3D _sampler, ivec3 P, int lod);
uvec4 texelFetch(usampler3D _sampler, ivec3 P, int lod);
vec4 texelFetch(sampler2DRect _sampler, ivec2 P);
ivec4 texelFetch(isampler2DRect _sampler, ivec2 P);
uvec4 texelFetch(usampler2DRect _sampler, ivec2 P);
vec4 texelFetch(sampler1DArray _sampler, ivec2 P, int lod);
ivec4 texelFetch(isampler1DArray _sampler, ivec2 P, int lod);
uvec4 texelFetch(usampler1DArray _sampler, ivec2 P, int lod);
vec4 texelFetch(sampler2DArray _sampler, ivec3 P, int lod);
ivec4 texelFetch(isampler2DArray _sampler, ivec3 P, int lod);
uvec4 texelFetch(usampler2DArray _sampler, ivec3 P, int lod);
vec4 texelFetch(samplerBuffer _sampler, int P);
ivec4 texelFetch(isamplerBuffer _sampler, int P);
uvec4 texelFetch(usamplerBuffer _sampler, int P);
vec4 texelFetch(sampler2DMS _sampler, ivec2 P, int sampleno);
ivec4 texelFetch(isampler2DMS _sampler, ivec2 P, int sampleno);
uvec4 texelFetch(usampler2DMS _sampler, ivec2 P, int sampleno);
vec4 texelFetch(sampler2DMSArray _sampler, ivec3 P, int sampleno);
ivec4 texelFetch(isampler2DMSArray _sampler, ivec3 P, int sampleno);
uvec4 texelFetch(usampler2DMSArray _sampler, ivec3 P, int sampleno);
vec4 texelFetchOffset(sampler1D _sampler, int P, int lod, int offset);
ivec4 texelFetchOffset(isampler1D _sampler, int P, int lod, int offset);
uvec4 texelFetchOffset(usampler1D _sampler, int P, int lod, int offset);
vec4 texelFetchOffset(sampler2D _sampler, ivec2 P, int lod, ivec2 offset);
ivec4 texelFetchOffset(isampler2D _sampler, ivec2 P, int lod, ivec2 offset);
uvec4 texelFetchOffset(usampler2D _sampler, ivec2 P, int lod, ivec2 offset);
vec4 texelFetchOffset(sampler3D _sampler, ivec3 P, int lod, ivec3 offset);
ivec4 texelFetchOffset(isampler3D _sampler, ivec3 P, int lod, ivec3 offset);
uvec4 texelFetchOffset(usampler3D _sampler, ivec3 P, int lod, ivec3 offset);
vec4 texelFetchOffset(sampler2DRect _sampler, ivec2 P, ivec2 offset);
ivec4 texelFetchOffset(isampler2DRect _sampler, ivec2 P, ivec2 offset);
uvec4 texelFetchOffset(usampler2DRect _sampler, ivec2 P, ivec2 offset);
vec4 texelFetchOffset(sampler1DArray _sampler, ivec2 P, int lod, int offset);
ivec4 texelFetchOffset(isampler1DArray _sampler, ivec2 P, int lod, int offset);
uvec4 texelFetchOffset(usampler1DArray _sampler, ivec2 P, int lod, int offset);
vec4 texelFetchOffset(sampler2DArray _sampler, ivec3 P, int lod, ivec2 offset);
ivec4 texelFetchOffset(isampler2DArray _sampler, ivec3 P, int lod, ivec2 offset);
uvec4 texelFetchOffset(usampler2DArray _sampler, ivec3 P, int lod, ivec2 offset);
vec4 textureProjOffset(sampler1D _sampler, vec2 P, int offset);
ivec4 textureProjOffset(isampler1D _sampler, vec2 P, int offset);
uvec4 textureProjOffset(usampler1D _sampler, vec2 P, int offset);
vec4 textureProjOffset(sampler1D _sampler, vec2 P, int offset, float bias);
ivec4 textureProjOffset(isampler1D _sampler, vec2 P, int offset, float bias);
uvec4 textureProjOffset(usampler1D _sampler, vec2 P, int offset, float bias);
vec4 textureProjOffset(sampler1D _sampler, vec4 P, int offset);
ivec4 textureProjOffset(isampler1D _sampler, vec4 P, int offset);
uvec4 textureProjOffset(usampler1D _sampler, vec4 P, int offset);
vec4 textureProjOffset(sampler1D _sampler, vec4 P, int offset, float bias);
ivec4 textureProjOffset(isampler1D _sampler, vec4 P, int offset, float bias);
uvec4 textureProjOffset(usampler1D _sampler, vec4 P, int offset, float bias);
vec4 textureProjOffset(sampler2D _sampler, vec3 P, ivec2 offset);
ivec4 textureProjOffset(isampler2D _sampler, vec3 P, ivec2 offset);
uvec4 textureProjOffset(usampler2D _sampler, vec3 P, ivec2 offset);
vec4 textureProjOffset(sampler2D _sampler, vec3 P, ivec2 offset, float bias);
ivec4 textureProjOffset(isampler2D _sampler, vec3 P, ivec2 offset, float bias);
uvec4 textureProjOffset(usampler2D _sampler, vec3 P, ivec2 offset, float bias);
vec4 textureProjOffset(sampler2D _sampler, vec4 P, ivec2 offset);
ivec4 textureProjOffset(isampler2D _sampler, vec4 P, ivec2 offset);
uvec4 textureProjOffset(usampler2D _sampler, vec4 P, ivec2 offset);
vec4 textureProjOffset(sampler2D _sampler, vec4 P, ivec2 offset, float bias);
ivec4 textureProjOffset(isampler2D _sampler, vec4 P, ivec2 offset, float bias);
uvec4 textureProjOffset(usampler2D _sampler, vec4 P, ivec2 offset, float bias);
vec4 textureProjOffset(sampler3D _sampler, vec4 P, ivec3 offset);
ivec4 textureProjOffset(isampler3D _sampler, vec4 P, ivec3 offset);
uvec4 textureProjOffset(usampler3D _sampler, vec4 P, ivec3 offset);
vec4 textureProjOffset(sampler3D _sampler, vec4 P, ivec3 offset, float bias);
ivec4 textureProjOffset(isampler3D _sampler, vec4 P, ivec3 offset, float bias);
uvec4 textureProjOffset(usampler3D _sampler, vec4 P, ivec3 offset, float bias);
vec4 textureProjOffset(sampler2DRect _sampler, vec3 P, ivec2 offset);
ivec4 textureProjOffset(isampler2DRect _sampler, vec3 P, ivec2 offset);
uvec4 textureProjOffset(usampler2DRect _sampler, vec3 P, ivec2 offset);
vec4 textureProjOffset(sampler2DRect _sampler, vec4 P, ivec2 offset);
ivec4 textureProjOffset(isampler2DRect _sampler, vec4 P, ivec2 offset);
uvec4 textureProjOffset(usampler2DRect _sampler, vec4 P, ivec2 offset);
float textureProjOffset(sampler2DRectShadow _sampler, vec4 P, ivec2 offset );
float textureProjOffset(sampler1DShadow _sampler, vec4 P, int offset);
float textureProjOffset(sampler1DShadow _sampler, vec4 P, int offset, float bias);
float textureProjOffset(sampler2DShadow _sampler, vec4 P, ivec2 offset);
float textureProjOffset(sampler2DShadow _sampler, vec4 P, ivec2 offset, float bias);
vec4 textureLodOffset(sampler1D _sampler, float P, float lod, int offset);
ivec4 textureLodOffset(isampler1D _sampler, float P, float lod, int offset);
uvec4 textureLodOffset(usampler1D _sampler, float P, float lod, int offset);
vec4 textureLodOffset(sampler2D _sampler, vec2 P, float lod, ivec2 offset);
ivec4 textureLodOffset(isampler2D _sampler, vec2 P, float lod, ivec2 offset);
uvec4 textureLodOffset(usampler2D _sampler, vec2 P, float lod, ivec2 offset);
vec4 textureLodOffset(sampler3D _sampler, vec3 P, float lod, ivec3 offset);
ivec4 textureLodOffset(isampler3D _sampler, vec3 P, float lod, ivec3 offset);
uvec4 textureLodOffset(usampler3D _sampler, vec3 P, float lod, ivec3 offset);
float textureLodOffset(sampler1DShadow _sampler, vec3 P, float lod, int offset);
float textureLodOffset(sampler2DShadow _sampler, vec3 P, float lod, ivec2 offset);
vec4 textureLodOffset(sampler1DArray _sampler, vec2 P, float lod, int offset);
ivec4 textureLodOffset(isampler1DArray _sampler, vec2 P, float lod, int offset);
uvec4 textureLodOffset(usampler1DArray _sampler, vec2 P, float lod, int offset);
vec4 textureLodOffset(sampler2DArray _sampler, vec3 P, float lod, ivec2 offset);
ivec4 textureLodOffset(isampler2DArray _sampler, vec3 P, float lod, ivec2 offset);
uvec4 textureLodOffset(usampler2DArray _sampler, vec3 P, float lod, ivec2 offset);
float textureLodOffset(sampler1DArrayShadow _sampler, vec3 P, float lod, int offset);
vec4 textureProjLod(sampler1D _sampler, vec2 P, float lod);
ivec4 textureProjLod(isampler1D _sampler, vec2 P, float lod);
uvec4 textureProjLod(usampler1D _sampler, vec2 P, float lod);
vec4 textureProjLod(sampler1D _sampler, vec4 P, float lod);
ivec4 textureProjLod(isampler1D _sampler, vec4 P, float lod);
uvec4 textureProjLod(usampler1D _sampler, vec4 P, float lod);
vec4 textureProjLod(sampler2D _sampler, vec3 P, float lod);
ivec4 textureProjLod(isampler2D _sampler, vec3 P, float lod);
uvec4 textureProjLod(usampler2D _sampler, vec3 P, float lod);
vec4 textureProjLod(sampler2D _sampler, vec4 P, float lod);
ivec4 textureProjLod(isampler2D _sampler, vec4 P, float lod);
uvec4 textureProjLod(usampler2D _sampler, vec4 P, float lod);
vec4 textureProjLod(sampler3D _sampler, vec4 P, float lod);
ivec4 textureProjLod(isampler3D _sampler, vec4 P, float lod);
uvec4 textureProjLod(usampler3D _sampler, vec4 P, float lod);
float textureProjLod(sampler1DShadow _sampler, vec4 P, float lod);
float textureProjLod(sampler2DShadow _sampler, vec4 P, float lod);
vec4 textureProjLodOffset(sampler1D _sampler, vec2 P, float lod, int offset);
ivec4 textureProjLodOffset(isampler1D _sampler, vec2 P, float lod, int offset);
uvec4 textureProjLodOffset(usampler1D _sampler, vec2 P, float lod, int offset);
vec4 textureProjLodOffset(sampler1D _sampler, vec4 P, float lod, int offset);
ivec4 textureProjLodOffset(isampler1D _sampler, vec4 P, float lod, int offset);
uvec4 textureProjLodOffset(usampler1D _sampler, vec4 P, float lod, int offset);
vec4 textureProjLodOffset(sampler2D _sampler, vec3 P, float lod, ivec2 offset);
ivec4 textureProjLodOffset(isampler2D _sampler, vec3 P, float lod, ivec2 offset);
uvec4 textureProjLodOffset(usampler2D _sampler, vec3 P, float lod, ivec2 offset);
vec4 textureProjLodOffset(sampler2D _sampler, vec4 P, float lod, ivec2 offset);
ivec4 textureProjLodOffset(isampler2D _sampler, vec4 P, float lod, ivec2 offset);
uvec4 textureProjLodOffset(usampler2D _sampler, vec4 P, float lod, ivec2 offset);
vec4 textureProjLodOffset(sampler3D _sampler, vec4 P, float lod, ivec3 offset);
ivec4 textureProjLodOffset(isampler3D _sampler, vec4 P, float lod, ivec3 offset);
uvec4 textureProjLodOffset(usampler3D _sampler, vec4 P, float lod, ivec3 offset);
float textureProjLodOffset(sampler1DShadow _sampler, vec4 P, float lod, int offset);
float textureProjLodOffset(sampler2DShadow _sampler, vec4 P, float lod, ivec2 offset);
vec4 textureGrad(sampler1D _sampler, float P, float dPdx, float dPdy);
ivec4 textureGrad(isampler1D _sampler, float P, float dPdx, float dPdy);
uvec4 textureGrad(usampler1D _sampler, float P, float dPdx, float dPdy);
vec4 textureGrad(sampler2D _sampler, vec2 P, vec2 dPdx, vec2 dPdy);
ivec4 textureGrad(isampler2D _sampler, vec2 P, vec2 dPdx, vec2 dPdy);
uvec4 textureGrad(usampler2D _sampler, vec2 P, vec2 dPdx, vec2 dPdy);
vec4 textureGrad(sampler3D _sampler, vec3 P, vec3 dPdx, vec3 dPdy);
ivec4 textureGrad(isampler3D _sampler, vec3 P, vec3 dPdx, vec3 dPdy);
uvec4 textureGrad(usampler3D _sampler, vec3 P, vec3 dPdx, vec3 dPdy);
vec4 textureGrad(samplerCube _sampler, vec3 P, vec3 dPdx, vec3 dPdy);
ivec4 textureGrad(isamplerCube _sampler, vec3 P, vec3 dPdx, vec3 dPdy);
uvec4 textureGrad(usamplerCube _sampler, vec3 P, vec3 dPdx, vec3 dPdy);
vec4 textureGrad(sampler2DRect _sampler, vec2 P, vec2 dPdx, vec2 dPdy);
ivec4 textureGrad(isampler2DRect _sampler, vec2 P, vec2 dPdx, vec2 dPdy);
uvec4 textureGrad(usampler2DRect _sampler, vec2 P, vec2 dPdx, vec2 dPdy);
float textureGrad(sampler2DRectShadow _sampler, vec3 P, vec2 dPdx, vec2 dPdy);
float textureGrad(sampler1DShadow _sampler, vec3 P, float dPdx, float dPdy);
float textureGrad(sampler2DShadow _sampler, vec3 P, vec2 dPdx, vec2 dPdy);
float textureGrad(samplerCubeShadow _sampler, vec4 P, vec3 dPdx, vec3 dPdy);
vec4 textureGrad(sampler1DArray _sampler, vec2 P, float dPdx, float dPdy);
ivec4 textureGrad(isampler1DArray _sampler, vec2 P, float dPdx, float dPdy);
uvec4 textureGrad(usampler1DArray _sampler, vec2 P, float dPdx, float dPdy);
vec4 textureGrad(sampler2DArray _sampler, vec3 P, vec2 dPdx, vec2 dPdy);
ivec4 textureGrad(isampler2DArray _sampler, vec3 P, vec2 dPdx, vec2 dPdy);
uvec4 textureGrad(usampler2DArray _sampler, vec3 P, vec2 dPdx, vec2 dPdy);
vec4 textureGrad(samplerCubeArray _sampler, vec4 P, vec3 dPdx, vec3 dPdy);
ivec4 textureGrad(isamplerCubeArray _sampler, vec4 P, vec3 dPdx, vec3 dPdy);
uvec4 textureGrad(usamplerCubeArray _sampler, vec4 P, vec3 dPdx, vec3 dPdy);
float textureGrad(sampler1DArrayShadow _sampler, vec3 P, float dPdx, float dPdy);
float textureGrad(sampler2DArrayShadow _sampler, vec4 P, vec2 dPdx, vec2 dPdy);
vec4 textureGradOffset(sampler1D _sampler, float P, float dPdx, float dPdy, int offset);
ivec4 textureGradOffset(isampler1D _sampler, float P, float dPdx, float dPdy, int offset);
uvec4 textureGradOffset(usampler1D _sampler, float P, float dPdx, float dPdy, int offset);
vec4 textureGradOffset(sampler2D _sampler, vec2 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
ivec4 textureGradOffset(isampler2D _sampler, vec2 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
uvec4 textureGradOffset(usampler2D _sampler, vec2 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
vec4 textureGradOffset(sampler3D _sampler, vec3 P, vec3 dPdx, vec3 dPdy, ivec3 offset);
ivec4 textureGradOffset(isampler3D _sampler, vec3 P, vec3 dPdx, vec3 dPdy, ivec3 offset);
uvec4 textureGradOffset(usampler3D _sampler, vec3 P, vec3 dPdx, vec3 dPdy, ivec3 offset);
vec4 textureGradOffset(sampler2DRect _sampler, vec2 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
ivec4 textureGradOffset(isampler2DRect _sampler, vec2 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
uvec4 textureGradOffset(usampler2DRect _sampler, vec2 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
float textureGradOffset(sampler2DRectShadow _sampler, vec3 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
float textureGradOffset(sampler1DShadow _sampler, vec3 P, float dPdx, float dPdy, int offset );
float textureGradOffset(sampler2DShadow _sampler, vec3 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
vec4 textureGradOffset(sampler1DArray _sampler, vec2 P, float dPdx, float dPdy, int offset);
ivec4 textureGradOffset(isampler1DArray _sampler, vec2 P, float dPdx, float dPdy, int offset);
uvec4 textureGradOffset(usampler1DArray _sampler, vec2 P, float dPdx, float dPdy, int offset);
vec4 textureGradOffset(sampler2DArray _sampler, vec3 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
ivec4 textureGradOffset(isampler2DArray _sampler, vec3 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
uvec4 textureGradOffset(usampler2DArray _sampler, vec3 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
float textureGradOffset(sampler1DArrayShadow _sampler, vec3 P, float dPdx, float dPdy, int offset);
float textureGradOffset(sampler2DArrayShadow _sampler, vec4 P,  vec2 dPdx, vec2 dPdy, ivec2 offset);
vec4 textureProjGrad(sampler1D _sampler, vec2 P, float dPdx, float dPdy);
ivec4 textureProjGrad(isampler1D _sampler, vec2 P, float dPdx, float dPdy);
uvec4 textureProjGrad(usampler1D _sampler, vec2 P, float dPdx, float dPdy);
vec4 textureProjGrad(sampler1D _sampler, vec4 P, float dPdx, float dPdy);
ivec4 textureProjGrad(isampler1D _sampler, vec4 P, float dPdx, float dPdy);
uvec4 textureProjGrad(usampler1D _sampler, vec4 P, float dPdx, float dPdy);
vec4 textureProjGrad(sampler2D _sampler, vec3 P, vec2 dPdx, vec2 dPdy);
ivec4 textureProjGrad(isampler2D _sampler, vec3 P, vec2 dPdx, vec2 dPdy);
uvec4 textureProjGrad(usampler2D _sampler, vec3 P, vec2 dPdx, vec2 dPdy);
vec4 textureProjGrad(sampler2D _sampler, vec4 P, vec2 dPdx, vec2 dPdy);
ivec4 textureProjGrad(isampler2D _sampler, vec4 P, vec2 dPdx, vec2 dPdy);
uvec4 textureProjGrad(usampler2D _sampler, vec4 P, vec2 dPdx, vec2 dPdy);
vec4 textureProjGrad(sampler3D _sampler, vec4 P, vec3 dPdx, vec3 dPdy);
ivec4 textureProjGrad(isampler3D _sampler, vec4 P, vec3 dPdx, vec3 dPdy);
uvec4 textureProjGrad(usampler3D _sampler, vec4 P, vec3 dPdx, vec3 dPdy);
vec4 textureProjGrad(sampler2DRect _sampler, vec3 P, vec2 dPdx, vec2 dPdy);
ivec4 textureProjGrad(isampler2DRect _sampler, vec3 P, vec2 dPdx, vec2 dPdy);
uvec4 textureProjGrad(usampler2DRect _sampler, vec3 P, vec2 dPdx, vec2 dPdy);
vec4 textureProjGrad(sampler2DRect _sampler, vec4 P, vec2 dPdx, vec2 dPdy);
ivec4 textureProjGrad(isampler2DRect _sampler, vec4 P, vec2 dPdx, vec2 dPdy);
uvec4 textureProjGrad(usampler2DRect _sampler, vec4 P, vec2 dPdx, vec2 dPdy);
float textureProjGrad(sampler2DRectShadow _sampler, vec4 P, vec2 dPdx, vec2 dPdy);
float textureProjGrad(sampler1DShadow _sampler, vec4 P, float dPdx, float dPdy);
float textureProjGrad(sampler2DShadow _sampler, vec4 P, vec2 dPdx, vec2 dPdy);
vec4 textureProjGradOffset(sampler1D _sampler, vec2 P, float dPdx, float dPdy, int offset);
ivec4 textureProjGradOffset(isampler1D _sampler, vec2 P, float dPdx, float dPdy, int offset);
uvec4 textureProjGradOffset(usampler1D _sampler, vec2 P, float dPdx, float dPdy, int offset);
vec4 textureProjGradOffset(sampler1D _sampler, vec4 P, float dPdx, float dPdy, int offset);
ivec4 textureProjGradOffset(isampler1D _sampler, vec4 P, float dPdx, float dPdy, int offset);
uvec4 textureProjGradOffset(usampler1D _sampler, vec4 P, float dPdx, float dPdy, int offset);
vec4 textureProjGradOffset(sampler2D _sampler, vec3 P, vec2 dPdx, vec2 dPdy, vec2 offset);
ivec4 textureProjGradOffset(isampler2D _sampler, vec3 P, vec2 dPdx, vec2 dPdy, vec2 offset);
uvec4 textureProjGradOffset(usampler2D _sampler, vec3 P, vec2 dPdx, vec2 dPdy, vec2 offset);
vec4 textureProjGradOffset(sampler2D _sampler, vec4 P, vec2 dPdx, vec2 dPdy, vec2 offset);
ivec4 textureProjGradOffset(isampler2D _sampler, vec4 P, vec2 dPdx, vec2 dPdy, vec2 offset);
uvec4 textureProjGradOffset(usampler2D _sampler, vec4 P, vec2 dPdx, vec2 dPdy, vec2 offset);
vec4 textureProjGradOffset(sampler3D _sampler, vec4 P, vec3 dPdx, vec3 dPdy, vec3 offset);
ivec4 textureProjGradOffset(isampler3D _sampler, vec4 P, vec3 dPdx, vec3 dPdy, vec3 offset);
uvec4 textureProjGradOffset(usampler3D _sampler, vec4 P, vec3 dPdx, vec3 dPdy, vec3 offset);
vec4 textureProjGradOffset(sampler2DRect _sampler, vec3 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
ivec4 textureProjGradOffset(isampler2DRect _sampler, vec3 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
uvec4 textureProjGradOffset(usampler2DRect _sampler, vec3 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
vec4 textureProjGradOffset(sampler2DRect _sampler, vec4 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
ivec4 textureProjGradOffset(isampler2DRect _sampler, vec4 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
uvec4 textureProjGradOffset(usampler2DRect _sampler, vec4 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
float textureProjGradOffset(sampler2DRectShadow _sampler, vec4 P, vec2 dPdx, vec2 dPdy, ivec2 offset);
float textureProjGradOffset(sampler1DShadow _sampler, vec4 P, float dPdx, float dPdy, int offset);
float textureProjGradOffset(sampler2DShadow _sampler, vec4 P, vec2 dPdx, vec2 dPdy, vec2 offset);

// Texture gather functions.
vec4 textureGather(sampler2D _sampler, vec2 P);
ivec4 textureGather(isampler2D _sampler, vec2 P);
uvec4 textureGather(usampler2D _sampler, vec2 P);
vec4 textureGather(sampler2D _sampler, vec2 P, int comp);
ivec4 textureGather(isampler2D _sampler, vec2 P, int comp);
uvec4 textureGather(usampler2D _sampler, vec2 P, int comp);
vec4 textureGather(sampler2DArray _sampler, vec3 P);
ivec4 textureGather(isampler2DArray _sampler, vec3 P);
uvec4 textureGather(usampler2DArray _sampler, vec3 P);
vec4 textureGather(sampler2DArray _sampler, vec3 P, int comp);
ivec4 textureGather(isampler2DArray _sampler, vec3 P, int comp);
uvec4 textureGather(usampler2DArray _sampler, vec3 P, int comp);
vec4 textureGather(samplerCube _sampler, vec3 P);
ivec4 textureGather(isamplerCube _sampler, vec3 P);
uvec4 textureGather(usamplerCube _sampler, vec3 P);
vec4 textureGather(samplerCube _sampler, vec3 P, int comp);
ivec4 textureGather(isamplerCube _sampler, vec3 P, int comp);
uvec4 textureGather(usamplerCube _sampler, vec3 P, int comp);
vec4 textureGather(samplerCubeArray _sampler, vec4 P);
ivec4 textureGather(isamplerCubeArray _sampler, vec4 P);
uvec4 textureGather(usamplerCubeArray _sampler, vec4 P);
vec4 textureGather(samplerCubeArray _sampler, vec4 P, int comp);
ivec4 textureGather(isamplerCubeArray _sampler, vec4 P, int comp);
uvec4 textureGather(usamplerCubeArray _sampler, vec4 P, int comp);
vec4 textureGather(sampler2DRect _sampler, vec2 P);
ivec4 textureGather(isampler2DRect _sampler, vec2 P);
uvec4 textureGather(usampler2DRect _sampler, vec2 P);
vec4 textureGather(sampler2DRect _sampler, vec2 P, int comp);
ivec4 textureGather(isampler2DRect _sampler, vec2 P, int comp);
uvec4 textureGather(usampler2DRect _sampler, vec2 P, int comp);
vec4 textureGather(sampler2DShadow _sampler, vec2 P, float refZ);
vec4 textureGather(sampler2DArrayShadow _sampler, vec3 P, float refZ);
vec4 textureGather(samplerCubeShadow _sampler, vec3 P, float refZ);
vec4 textureGather(samplerCubeArrayShadow _sampler, vec4 P, float refZ);
vec4 textureGather(sampler2DRectShadow _sampler, vec2 P, float refZ);
vec4 textureGatherOffset(sampler2D _sampler, vec2 P, ivec2 offset);
ivec4 textureGatherOffset(isampler2D _sampler, vec2 P, ivec2 offset);
uvec4 textureGatherOffset(usampler2D _sampler, vec2 P, ivec2 offset);
vec4 textureGatherOffset(sampler2D _sampler, vec2 P, ivec2 offset, int comp);
ivec4 textureGatherOffset(isampler2D _sampler, vec2 P, ivec2 offset, int comp);
uvec4 textureGatherOffset(usampler2D _sampler, vec2 P, ivec2 offset, int comp);
vec4 textureGatherOffset(sampler2DArray _sampler, vec3 P, ivec2 offset);
ivec4 textureGatherOffset(isampler2DArray _sampler, vec3 P, ivec2 offset);
uvec4 textureGatherOffset(usampler2DArray _sampler, vec3 P, ivec2 offset);
vec4 textureGatherOffset(sampler2DArray _sampler, vec3 P, ivec2 offset, int comp);
ivec4 textureGatherOffset(isampler2DArray _sampler, vec3 P, ivec2 offset, int comp);
uvec4 textureGatherOffset(usampler2DArray _sampler, vec3 P, ivec2 offset, int comp);
vec4 textureGatherOffset(sampler2DShadow _sampler, vec2 P, float refZ, ivec2 offset);
vec4 textureGatherOffset(sampler2DArrayShadow _sampler, vec3 P, float refZ, ivec2 offset);
vec4 textureGatherOffset(sampler2DRect _sampler, vec2 P, ivec2 offset);
ivec4 textureGatherOffset(isampler2DRect _sampler, vec2 P, ivec2 offset);
uvec4 textureGatherOffset(usampler2DRect _sampler, vec2 P, ivec2 offset);
vec4 textureGatherOffset(sampler2DRect _sampler, vec2 P, ivec2 offset, int comp);
ivec4 textureGatherOffset(isampler2DRect _sampler, vec2 P, ivec2 offset, int comp);
uvec4 textureGatherOffset(usampler2DRect _sampler, vec2 P, ivec2 offset, int comp);
vec4 textureGatherOffset(sampler2DRectShadow _sampler, vec2 P, float refZ, ivec2 offset);
vec4 textureGatherOffsets(sampler2D _sampler, vec2 P, ivec2 offsets[4]);
ivec4 textureGatherOffsets(isampler2D _sampler, vec2 P, ivec2 offsets[4]);
uvec4 textureGatherOffsets(usampler2D _sampler, vec2 P, ivec2 offsets[4]);
vec4 textureGatherOffsets(sampler2D _sampler, vec2 P, ivec2 offsets[4], int comp);
ivec4 textureGatherOffsets(isampler2D _sampler, vec2 P, ivec2 offsets[4], int comp);
uvec4 textureGatherOffsets(usampler2D _sampler, vec2 P, ivec2 offsets[4], int comp);
vec4 textureGatherOffsets(sampler2DArray _sampler, vec3 P, ivec2 offsets[4]);
ivec4 textureGatherOffsets(isampler2DArray _sampler, vec3 P, ivec2 offsets[4]);
uvec4 textureGatherOffsets(usampler2DArray _sampler, vec3 P, ivec2 offsets[4]);
vec4 textureGatherOffsets(sampler2DArray _sampler, vec3 P, ivec2 offsets[4], int comp);
ivec4 textureGatherOffsets(isampler2DArray _sampler, vec3 P, ivec2 offsets[4], int comp);
uvec4 textureGatherOffsets(usampler2DArray _sampler, vec3 P, ivec2 offsets[4], int comp);
vec4 textureGatherOffsets(sampler2DShadow _sampler, vec2 P, float refZ, ivec2 offsets[4]);
vec4 textureGatherOffsets(sampler2DArrayShadow _sampler, vec3 P, float refZ, ivec2 offsets[4]);
vec4 textureGatherOffsets(sampler2DRect _sampler, vec2 P, ivec2 offsets[4]);
ivec4 textureGatherOffsets(isampler2DRect _sampler, vec2 P, ivec2 offsets[4]);
uvec4 textureGatherOffsets(usampler2DRect _sampler, vec2 P, ivec2 offsets[4]);
vec4 textureGatherOffsets(sampler2DRect _sampler, vec2 P, ivec2 offsets[4], int comp);
ivec4 textureGatherOffsets(isampler2DRect _sampler, vec2 P, ivec2 offsets[4], int comp);
uvec4 textureGatherOffsets(usampler2DRect _sampler, vec2 P, ivec2 offsets[4], int comp);
vec4 textureGatherOffsets(sampler2DRectShadow _sampler, vec2 P, float refZ, ivec2 offsets[4]);

// Atomic counter functions.
uint atomicCounterIncrement(atomic_uint c);
uint atomicCounterDecrement(atomic_uint c);
uint atomicCounter(atomic_uint c);
uint atomicCounterAdd(atomic_uint c, uint data);
uint atomicCounterSubtract(atomic_uint c, uint data);
uint atomicCounterMin(atomic_uint c, uint data);
uint atomicCounterMax(atomic_uint c, uint data);
uint atomicCounterAnd(atomic_uint c, uint data);
uint atomicCounterOr(atomic_uint c, uint data);
uint atomicCounterXor(atomic_uint c, uint data);
uint atomicCounterExchange(atomic_uint c, uint data);
uint atomicCounterCompSwap(atomic_uint c, uint compare, uint data);

// Atomic memory functions.
uint atomicAdd(inout uint mem, uint data);
int atomicAdd(inout int mem, int data);
uint atomicMin(inout uint mem, uint data);
int atomicMin(inout int mem, int data);
uint atomicMax(inout uint mem, uint data);
int atomicMax(inout int mem, int data);
uint atomicAnd(inout uint mem, uint data);
int atomicAnd(inout int mem, int data);
uint atomicOr(inout uint mem, uint data);
int atomicOr(inout int mem, int data);
uint atomicXor(inout uint mem, uint data);
int atomicXor(inout int mem, int data);
uint atomicExchange(inout uint mem, uint data);
int atomicExchange(inout int mem, int data);
uint atomicCompSwap(inout uint mem, uint data);
int atomicCompSwap(inout int mem, int data);

// Image functions.
int imageSize(readonly writeonly image1D image);
int imageSize(readonly writeonly iimage1D image);
int imageSize(readonly writeonly uimage1D image);
ivec2 imageSize(readonly writeonly image2D image);
ivec2 imageSize(readonly writeonly iimage2D image);
ivec2 imageSize(readonly writeonly uimage2D image);
ivec3 imageSize(readonly writeonly image3D image);
ivec3 imageSize(readonly writeonly iimage3D image);
ivec3 imageSize(readonly writeonly uimage3D image);
ivec2 imageSize(readonly writeonly imageCube image);
ivec2 imageSize(readonly writeonly iimageCube image);
ivec2 imageSize(readonly writeonly uimageCube image);
ivec3 imageSize(readonly writeonly imageCubeArray image);
ivec3 imageSize(readonly writeonly iimageCubeArray image);
ivec3 imageSize(readonly writeonly uimageCubeArray image);
ivec3 imageSize(readonly writeonly image2DArray image);
ivec3 imageSize(readonly writeonly iimage2DArray image);
ivec3 imageSize(readonly writeonly uimage2DArray image);
ivec2 imageSize(readonly writeonly image2DRect image);
ivec2 imageSize(readonly writeonly iimage2DRect image);
ivec2 imageSize(readonly writeonly uimage2DRect image);
ivec2 imageSize(readonly writeonly image1DArray image);
ivec2 imageSize(readonly writeonly iimage1DArray image);
ivec2 imageSize(readonly writeonly uimage1DArray image);
ivec2 imageSize(readonly writeonly image2DMS image);
ivec2 imageSize(readonly writeonly iimage2DMS image);
ivec2 imageSize(readonly writeonly uimage2DMS image);
ivec3 imageSize(readonly writeonly imageBuffer image);
ivec3 imageSize(readonly writeonly iimageBuffer image);
ivec3 imageSize(readonly writeonly uimageBuffer image);
int imageSamples(readonly writeonly image2DMS image);
int imageSamples(readonly writeonly iimage2DMS image);
int imageSamples(readonly writeonly uimage2DMS image);
int imageSamples(readonly writeonly image2DMSArray image);
int imageSamples(readonly writeonly iimage2DMSArray image);
int imageSamples(readonly writeonly uimage2DMSArray image);
uvec4 imageLoad(readonly uimage2DMSArray image, ivec3 P, int _sample);
ivec4 imageLoad(readonly iimage2DMSArray image, ivec3 P, int _sample);
vec4 imageLoad(readonly image2DMSArray image, ivec3 P, int _sample);
uvec4 imageLoad(readonly uimage2DMS image, ivec2 P, int _sample);
ivec4 imageLoad(readonly iimage2DMS image, ivec2 P, int _sample);
vec4 imageLoad(readonly image2DMS image, ivec2 P, int _sample);
uvec4 imageLoad(readonly uimage2DRect image, ivec2 P);
ivec4 imageLoad(readonly iimage2DRect image, ivec2 P);
vec4 imageLoad(readonly image2DRect image, ivec2 P);
uvec4 imageLoad(readonly uimage1DArray image, ivec2 P);
ivec4 imageLoad(readonly iimage1DArray image, ivec2 P);
vec4 imageLoad(readonly image1DArray image, ivec2 P);
uvec4 imageLoad(readonly uimage1D image, int P);
ivec4 imageLoad(readonly iimage1D image, int P);
vec4 imageLoad(readonly image1D image, int P);
uvec4 imageLoad(readonly uimageCubeArray image, ivec3 P);
ivec4 imageLoad(readonly iimageCubeArray image, ivec3 P);
vec4 imageLoad(readonly imageCubeArray image, ivec3 P);
uvec4 imageLoad(readonly uimage2DArray image, ivec3 P);
ivec4 imageLoad(readonly iimage2DArray image, ivec3 P);
vec4 imageLoad(readonly image2DArray image, ivec3 P);
uvec4 imageLoad(readonly uimageBuffer image, int P);
ivec4 imageLoad(readonly iimageBuffer image, int P);
vec4 imageLoad(readonly imageBuffer image, int P);
uvec4 imageLoad(readonly uimageCube image, ivec3 P);
ivec4 imageLoad(readonly iimageCube image, ivec3 P);
vec4 imageLoad(readonly imageCube image, ivec3 P);
uvec4 imageLoad(readonly uimage3D image, ivec3 P);
ivec4 imageLoad(readonly iimage3D image, ivec3 P);
vec4 imageLoad(readonly image3D image, ivec3 P);
uvec4 imageLoad(readonly uimage2D image, ivec2 P);
ivec4 imageLoad(readonly iimage2D image, ivec2 P);
vec4 imageLoad(readonly image2D image, ivec2 P);
void imageStore(writeonly image2D image, ivec2 P, vec4 data);
void imageStore(writeonly iimage2D image, ivec2 P, ivec4 data);
void imageStore(writeonly uimage2D image, ivec2 P, uvec4 data);
void imageStore(writeonly image3D image, ivec3 P, vec4 data);
void imageStore(writeonly iimage3D image, ivec3 P, ivec4 data);
void imageStore(writeonly uimage3D image, ivec3 P, uvec4 data);
void imageStore(writeonly imageCube image, ivec3 P, vec4 data);
void imageStore(writeonly iimageCube image, ivec3 P, ivec4 data);
void imageStore(writeonly uimageCube image, ivec3 P, uvec4 data);
void imageStore(writeonly imageBuffer image, int P, vec4 data);
void imageStore(writeonly iimageBuffer image, int P, ivec4 data);
void imageStore(writeonly uimageBuffer image, int P, uvec4 data);
void imageStore(writeonly image2DArray image, ivec3 P, vec4 data);
void imageStore(writeonly iimage2DArray image, ivec3 P, ivec4 data);
void imageStore(writeonly uimage2DArray image, ivec3 P, uvec4 data);
void imageStore(writeonly imageCubeArray image, ivec3 P, vec4 data);
void imageStore(writeonly iimageCubeArray image, ivec3 P, ivec4 data);
void imageStore(writeonly uimageCubeArray image, ivec3 P, uvec4 data);
void imageStore(writeonly image1D image, int P, vec4 data);
void imageStore(writeonly iimage1D image, int P, ivec4 data);
void imageStore(writeonly uimage1D image, int P, uvec4 data);
void imageStore(writeonly image1DArray image, ivec2 P, vec4 data);
void imageStore(writeonly iimage1DArray image, ivec2 P, ivec4 data);
void imageStore(writeonly uimage1DArray image, ivec2 P, uvec4 data);
void imageStore(writeonly image2DRect image, ivec2 P, vec4 data);
void imageStore(writeonly iimage2DRect image, ivec2 P, ivec4 data);
void imageStore(writeonly uimage2DRect image, ivec2 P, uvec4 data);
void imageStore(writeonly image2DMS image, ivec2 P, int _sample, vec4 data);
void imageStore(writeonly iimage2DMS image, ivec2 P, int _sample, ivec4 data);
void imageStore(writeonly uimage2DMS image, ivec2 P, int _sample, uvec4 data);
void imageStore(writeonly image2DMSArray image, ivec3 P, int _sample, vec4 data);
void imageStore(writeonly iimage2DMSArray image, ivec3 P, int _sample, ivec4 data);
void imageStore(writeonly uimage2DMSArray image, ivec3 P, int _sample, uvec4 data);
uint imageAtomicAdd(image2D image, ivec2 P, uint data);
uint imageAtomicAdd(iimage2D image, ivec2 P, uint data);
uint imageAtomicAdd(uimage2D image, ivec2 P, uint data);
uint imageAtomicAdd(image3D image, ivec3 P, uint data);
uint imageAtomicAdd(iimage3D image, ivec3 P, uint data);
uint imageAtomicAdd(uimage3D image, ivec3 P, uint data);
uint imageAtomicAdd(imageCube image, ivec3 P, uint data);
uint imageAtomicAdd(iimageCube image, ivec3 P, uint data);
uint imageAtomicAdd(uimageCube image, ivec3 P, uint data);
uint imageAtomicAdd(imageBuffer image, int P, uint data);
uint imageAtomicAdd(iimageBuffer image, int P, uint data);
uint imageAtomicAdd(uimageBuffer image, int P, uint data);
uint imageAtomicAdd(image2DArray image, ivec3 P, uint data);
uint imageAtomicAdd(iimage2DArray image, ivec3 P, uint data);
uint imageAtomicAdd(uimage2DArray image, ivec3 P, uint data);
uint imageAtomicAdd(imageCubeArray image, ivec3 P, uint data);
uint imageAtomicAdd(iimageCubeArray image, ivec3 P, uint data);
uint imageAtomicAdd(uimageCubeArray image, ivec3 P, uint data);
uint imageAtomicAdd(image1D image, int P, uint data);
uint imageAtomicAdd(iimage1D image, int P, uint data);
uint imageAtomicAdd(uimage1D image, int P, uint data);
uint imageAtomicAdd(image1DArray image, ivec2 P, uint data);
uint imageAtomicAdd(iimage1DArray image, ivec2 P, uint data);
uint imageAtomicAdd(uimage1DArray image, ivec2 P, uint data);
uint imageAtomicAdd(image2DRect image, ivec2 P, uint data);
uint imageAtomicAdd(iimage2DRect image, ivec2 P, uint data);
uint imageAtomicAdd(uimage2DRect image, ivec2 P, uint data);
uint imageAtomicAdd(image2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicAdd(iimage2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicAdd(uimage2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicAdd(image2DMSArray image, ivec3 P, int _sample, uint data);
uint imageAtomicAdd(iimage2DMSArray image, ivec3 P, int _sample, uint data);
uint imageAtomicAdd(uimage2DMSArray image, ivec3 P, int _sample, uint data);
int imageAtomicAdd(image2D image, ivec2 P, int data);
int imageAtomicAdd(iimage2D image, ivec2 P, int data);
int imageAtomicAdd(uimage2D image, ivec2 P, int data);
int imageAtomicAdd(image3D image, ivec3 P, int data);
int imageAtomicAdd(iimage3D image, ivec3 P, int data);
int imageAtomicAdd(uimage3D image, ivec3 P, int data);
int imageAtomicAdd(imageCube image, ivec3 P, int data);
int imageAtomicAdd(iimageCube image, ivec3 P, int data);
int imageAtomicAdd(uimageCube image, ivec3 P, int data);
int imageAtomicAdd(imageBuffer image, int P, int data);
int imageAtomicAdd(iimageBuffer image, int P, int data);
int imageAtomicAdd(uimageBuffer image, int P, int data);
int imageAtomicAdd(image2DArray image, ivec3 P, int data);
int imageAtomicAdd(iimage2DArray image, ivec3 P, int data);
int imageAtomicAdd(uimage2DArray image, ivec3 P, int data);
int imageAtomicAdd(imageCubeArray image, ivec3 P, int data);
int imageAtomicAdd(iimageCubeArray image, ivec3 P, int data);
int imageAtomicAdd(uimageCubeArray image, ivec3 P, int data);
int imageAtomicAdd(image1D image, int P, int data);
int imageAtomicAdd(iimage1D image, int P, int data);
int imageAtomicAdd(uimage1D image, int P, int data);
int imageAtomicAdd(image1DArray image, ivec2 P, int data);
int imageAtomicAdd(iimage1DArray image, ivec2 P, int data);
int imageAtomicAdd(uimage1DArray image, ivec2 P, int data);
int imageAtomicAdd(image2DRect image, ivec2 P, int data);
int imageAtomicAdd(iimage2DRect image, ivec2 P, int data);
int imageAtomicAdd(uimage2DRect image, ivec2 P, int data);
int imageAtomicAdd(image2DMS image, ivec2 P, int _sample, int data);
int imageAtomicAdd(iimage2DMS image, ivec2 P, int _sample, int data);
int imageAtomicAdd(uimage2DMS image, ivec2 P, int _sample, int data);
int imageAtomicAdd(image2DMSArray image, ivec3 P, int _sample, int data);
int imageAtomicAdd(iimage2DMSArray image, ivec3 P, int _sample, int data);
int imageAtomicAdd(uimage2DMSArray image, ivec3 P, int _sample, int data);
uint imageAtomicMin(image2D image, ivec2 P, uint data);
uint imageAtomicMin(iimage2D image, ivec2 P, uint data);
uint imageAtomicMin(uimage2D image, ivec2 P, uint data);
uint imageAtomicMin(image3D image, ivec3 P, uint data);
uint imageAtomicMin(iimage3D image, ivec3 P, uint data);
uint imageAtomicMin(uimage3D image, ivec3 P, uint data);
uint imageAtomicMin(imageCube image, ivec3 P, uint data);
uint imageAtomicMin(iimageCube image, ivec3 P, uint data);
uint imageAtomicMin(uimageCube image, ivec3 P, uint data);
uint imageAtomicMin(imageBuffer image, int P, uint data);
uint imageAtomicMin(iimageBuffer image, int P, uint data);
uint imageAtomicMin(uimageBuffer image, int P, uint data);
uint imageAtomicMin(image2DArray image, ivec3 P, uint data);
uint imageAtomicMin(iimage2DArray image, ivec3 P, uint data);
uint imageAtomicMin(uimage2DArray image, ivec3 P, uint data);
uint imageAtomicMin(imageCubeArray image, ivec3 P, uint data);
uint imageAtomicMin(iimageCubeArray image, ivec3 P, uint data);
uint imageAtomicMin(uimageCubeArray image, ivec3 P, uint data);
uint imageAtomicMin(image1D image, int P, uint data);
uint imageAtomicMin(iimage1D image, int P, uint data);
uint imageAtomicMin(uimage1D image, int P, uint data);
uint imageAtomicMin(image1DArray image, ivec2 P, uint data);
uint imageAtomicMin(iimage1DArray image, ivec2 P, uint data);
uint imageAtomicMin(uimage1DArray image, ivec2 P, uint data);
uint imageAtomicMin(image2DRect image, ivec2 P, uint data);
uint imageAtomicMin(iimage2DRect image, ivec2 P, uint data);
uint imageAtomicMin(uimage2DRect image, ivec2 P, uint data);
uint imageAtomicMin(image2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicMin(iimage2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicMin(uimage2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicMin(image2DMSArray image, ivec3 P, int _sample, uint data);
uint imageAtomicMin(iimage2DMSArray image, ivec3 P, int _sample, uint data);
uint imageAtomicMin(uimage2DMSArray image, ivec3 P, int _sample, uint data);
int imageAtomicMin(image2D image, ivec2 P, int data);
int imageAtomicMin(iimage2D image, ivec2 P, int data);
int imageAtomicMin(uimage2D image, ivec2 P, int data);
int imageAtomicMin(image3D image, ivec3 P, int data);
int imageAtomicMin(iimage3D image, ivec3 P, int data);
int imageAtomicMin(uimage3D image, ivec3 P, int data);
int imageAtomicMin(imageCube image, ivec3 P, int data);
int imageAtomicMin(iimageCube image, ivec3 P, int data);
int imageAtomicMin(uimageCube image, ivec3 P, int data);
int imageAtomicMin(imageBuffer image, int P, int data);
int imageAtomicMin(iimageBuffer image, int P, int data);
int imageAtomicMin(uimageBuffer image, int P, int data);
int imageAtomicMin(image2DArray image, ivec3 P, int data);
int imageAtomicMin(iimage2DArray image, ivec3 P, int data);
int imageAtomicMin(uimage2DArray image, ivec3 P, int data);
int imageAtomicMin(imageCubeArray image, ivec3 P, int data);
int imageAtomicMin(iimageCubeArray image, ivec3 P, int data);
int imageAtomicMin(uimageCubeArray image, ivec3 P, int data);
int imageAtomicMin(image1D image, int P, int data);
int imageAtomicMin(iimage1D image, int P, int data);
int imageAtomicMin(uimage1D image, int P, int data);
int imageAtomicMin(image1DArray image, ivec2 P, int data);
int imageAtomicMin(iimage1DArray image, ivec2 P, int data);
int imageAtomicMin(uimage1DArray image, ivec2 P, int data);
int imageAtomicMin(image2DRect image, ivec2 P, int data);
int imageAtomicMin(iimage2DRect image, ivec2 P, int data);
int imageAtomicMin(uimage2DRect image, ivec2 P, int data);
int imageAtomicMin(image2DMS image, ivec2 P, int _sample, int data);
int imageAtomicMin(iimage2DMS image, ivec2 P, int _sample, int data);
int imageAtomicMin(uimage2DMS image, ivec2 P, int _sample, int data);
int imageAtomicMin(image2DMSArray image, ivec3 P, int _sample, int data);
int imageAtomicMin(iimage2DMSArray image, ivec3 P, int _sample, int data);
int imageAtomicMin(uimage2DMSArray image, ivec3 P, int _sample, int data);
uint imageAtomicMax(image2D image, ivec2 P, uint data);
uint imageAtomicMax(iimage2D image, ivec2 P, uint data);
uint imageAtomicMax(uimage2D image, ivec2 P, uint data);
uint imageAtomicMax(image3D image, ivec3 P, uint data);
uint imageAtomicMax(iimage3D image, ivec3 P, uint data);
uint imageAtomicMax(uimage3D image, ivec3 P, uint data);
uint imageAtomicMax(imageCube image, ivec3 P, uint data);
uint imageAtomicMax(iimageCube image, ivec3 P, uint data);
uint imageAtomicMax(uimageCube image, ivec3 P, uint data);
uint imageAtomicMax(imageBuffer image, int P, uint data);
uint imageAtomicMax(iimageBuffer image, int P, uint data);
uint imageAtomicMax(uimageBuffer image, int P, uint data);
uint imageAtomicMax(image2DArray image, ivec3 P, uint data);
uint imageAtomicMax(iimage2DArray image, ivec3 P, uint data);
uint imageAtomicMax(uimage2DArray image, ivec3 P, uint data);
uint imageAtomicMax(imageCubeArray image, ivec3 P, uint data);
uint imageAtomicMax(iimageCubeArray image, ivec3 P, uint data);
uint imageAtomicMax(uimageCubeArray image, ivec3 P, uint data);
uint imageAtomicMax(image1D image, int P, uint data);
uint imageAtomicMax(iimage1D image, int P, uint data);
uint imageAtomicMax(uimage1D image, int P, uint data);
uint imageAtomicMax(image1DArray image, ivec2 P, uint data);
uint imageAtomicMax(iimage1DArray image, ivec2 P, uint data);
uint imageAtomicMax(uimage1DArray image, ivec2 P, uint data);
uint imageAtomicMax(image2DRect image, ivec2 P, uint data);
uint imageAtomicMax(iimage2DRect image, ivec2 P, uint data);
uint imageAtomicMax(uimage2DRect image, ivec2 P, uint data);
uint imageAtomicMax(image2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicMax(iimage2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicMax(uimage2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicMax(image2DMSArray image, ivec3 P, int _sample, uint data);
uint imageAtomicMax(iimage2DMSArray image, ivec3 P, int _sample, uint data);
uint imageAtomicMax(uimage2DMSArray image, ivec3 P, int _sample, uint data);
int imageAtomicMax(image2D image, ivec2 P, int data);
int imageAtomicMax(iimage2D image, ivec2 P, int data);
int imageAtomicMax(uimage2D image, ivec2 P, int data);
int imageAtomicMax(image3D image, ivec3 P, int data);
int imageAtomicMax(iimage3D image, ivec3 P, int data);
int imageAtomicMax(uimage3D image, ivec3 P, int data);
int imageAtomicMax(imageCube image, ivec3 P, int data);
int imageAtomicMax(iimageCube image, ivec3 P, int data);
int imageAtomicMax(uimageCube image, ivec3 P, int data);
int imageAtomicMax(imageBuffer image, int P, int data);
int imageAtomicMax(iimageBuffer image, int P, int data);
int imageAtomicMax(uimageBuffer image, int P, int data);
int imageAtomicMax(image2DArray image, ivec3 P, int data);
int imageAtomicMax(iimage2DArray image, ivec3 P, int data);
int imageAtomicMax(uimage2DArray image, ivec3 P, int data);
int imageAtomicMax(imageCubeArray image, ivec3 P, int data);
int imageAtomicMax(iimageCubeArray image, ivec3 P, int data);
int imageAtomicMax(uimageCubeArray image, ivec3 P, int data);
int imageAtomicMax(image1D image, int P, int data);
int imageAtomicMax(iimage1D image, int P, int data);
int imageAtomicMax(uimage1D image, int P, int data);
int imageAtomicMax(image1DArray image, ivec2 P, int data);
int imageAtomicMax(iimage1DArray image, ivec2 P, int data);
int imageAtomicMax(uimage1DArray image, ivec2 P, int data);
int imageAtomicMax(image2DRect image, ivec2 P, int data);
int imageAtomicMax(iimage2DRect image, ivec2 P, int data);
int imageAtomicMax(uimage2DRect image, ivec2 P, int data);
int imageAtomicMax(image2DMS image, ivec2 P, int _sample, int data);
int imageAtomicMax(iimage2DMS image, ivec2 P, int _sample, int data);
int imageAtomicMax(uimage2DMS image, ivec2 P, int _sample, int data);
int imageAtomicMax(image2DMSArray image, ivec3 P, int _sample, int data);
int imageAtomicMax(iimage2DMSArray image, ivec3 P, int _sample, int data);
int imageAtomicMax(uimage2DMSArray image, ivec3 P, int _sample, int data);
uint imageAtomicAnd(image2D image, ivec2 P, uint data);
uint imageAtomicAnd(iimage2D image, ivec2 P, uint data);
uint imageAtomicAnd(uimage2D image, ivec2 P, uint data);
uint imageAtomicAnd(image3D image, ivec3 P, uint data);
uint imageAtomicAnd(iimage3D image, ivec3 P, uint data);
uint imageAtomicAnd(uimage3D image, ivec3 P, uint data);
uint imageAtomicAnd(imageCube image, ivec3 P, uint data);
uint imageAtomicAnd(iimageCube image, ivec3 P, uint data);
uint imageAtomicAnd(uimageCube image, ivec3 P, uint data);
uint imageAtomicAnd(imageBuffer image, int P, uint data);
uint imageAtomicAnd(iimageBuffer image, int P, uint data);
uint imageAtomicAnd(uimageBuffer image, int P, uint data);
uint imageAtomicAnd(image2DArray image, ivec3 P, uint data);
uint imageAtomicAnd(iimage2DArray image, ivec3 P, uint data);
uint imageAtomicAnd(uimage2DArray image, ivec3 P, uint data);
uint imageAtomicAnd(imageCubeArray image, ivec3 P, uint data);
uint imageAtomicAnd(iimageCubeArray image, ivec3 P, uint data);
uint imageAtomicAnd(uimageCubeArray image, ivec3 P, uint data);
uint imageAtomicAnd(image1D image, int P, uint data);
uint imageAtomicAnd(iimage1D image, int P, uint data);
uint imageAtomicAnd(uimage1D image, int P, uint data);
uint imageAtomicAnd(image1DArray image, ivec2 P, uint data);
uint imageAtomicAnd(iimage1DArray image, ivec2 P, uint data);
uint imageAtomicAnd(uimage1DArray image, ivec2 P, uint data);
uint imageAtomicAnd(image2DRect image, ivec2 P, uint data);
uint imageAtomicAnd(iimage2DRect image, ivec2 P, uint data);
uint imageAtomicAnd(uimage2DRect image, ivec2 P, uint data);
uint imageAtomicAnd(image2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicAnd(iimage2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicAnd(uimage2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicAnd(image2DMSArray image, ivec3 P, int _sample, uint data);
uint imageAtomicAnd(iimage2DMSArray image, ivec3 P, int _sample, uint data);
uint imageAtomicAnd(uimage2DMSArray image, ivec3 P, int _sample, uint data);
int imageAtomicAnd(image2D image, ivec2 P, int data);
int imageAtomicAnd(iimage2D image, ivec2 P, int data);
int imageAtomicAnd(uimage2D image, ivec2 P, int data);
int imageAtomicAnd(image3D image, ivec3 P, int data);
int imageAtomicAnd(iimage3D image, ivec3 P, int data);
int imageAtomicAnd(uimage3D image, ivec3 P, int data);
int imageAtomicAnd(imageCube image, ivec3 P, int data);
int imageAtomicAnd(iimageCube image, ivec3 P, int data);
int imageAtomicAnd(uimageCube image, ivec3 P, int data);
int imageAtomicAnd(imageBuffer image, int P, int data);
int imageAtomicAnd(iimageBuffer image, int P, int data);
int imageAtomicAnd(uimageBuffer image, int P, int data);
int imageAtomicAnd(image2DArray image, ivec3 P, int data);
int imageAtomicAnd(iimage2DArray image, ivec3 P, int data);
int imageAtomicAnd(uimage2DArray image, ivec3 P, int data);
int imageAtomicAnd(imageCubeArray image, ivec3 P, int data);
int imageAtomicAnd(iimageCubeArray image, ivec3 P, int data);
int imageAtomicAnd(uimageCubeArray image, ivec3 P, int data);
int imageAtomicAnd(image1D image, int P, int data);
int imageAtomicAnd(iimage1D image, int P, int data);
int imageAtomicAnd(uimage1D image, int P, int data);
int imageAtomicAnd(image1DArray image, ivec2 P, int data);
int imageAtomicAnd(iimage1DArray image, ivec2 P, int data);
int imageAtomicAnd(uimage1DArray image, ivec2 P, int data);
int imageAtomicAnd(image2DRect image, ivec2 P, int data);
int imageAtomicAnd(iimage2DRect image, ivec2 P, int data);
int imageAtomicAnd(uimage2DRect image, ivec2 P, int data);
int imageAtomicAnd(image2DMS image, ivec2 P, int _sample, int data);
int imageAtomicAnd(iimage2DMS image, ivec2 P, int _sample, int data);
int imageAtomicAnd(uimage2DMS image, ivec2 P, int _sample, int data);
int imageAtomicAnd(image2DMSArray image, ivec3 P, int _sample, int data);
int imageAtomicAnd(iimage2DMSArray image, ivec3 P, int _sample, int data);
int imageAtomicAnd(uimage2DMSArray image, ivec3 P, int _sample, int data);
uint imageAtomicOr(image2D image, ivec2 P, uint data);
uint imageAtomicOr(iimage2D image, ivec2 P, uint data);
uint imageAtomicOr(uimage2D image, ivec2 P, uint data);
uint imageAtomicOr(image3D image, ivec3 P, uint data);
uint imageAtomicOr(iimage3D image, ivec3 P, uint data);
uint imageAtomicOr(uimage3D image, ivec3 P, uint data);
uint imageAtomicOr(imageCube image, ivec3 P, uint data);
uint imageAtomicOr(iimageCube image, ivec3 P, uint data);
uint imageAtomicOr(uimageCube image, ivec3 P, uint data);
uint imageAtomicOr(imageBuffer image, int P, uint data);
uint imageAtomicOr(iimageBuffer image, int P, uint data);
uint imageAtomicOr(uimageBuffer image, int P, uint data);
uint imageAtomicOr(image2DArray image, ivec3 P, uint data);
uint imageAtomicOr(iimage2DArray image, ivec3 P, uint data);
uint imageAtomicOr(uimage2DArray image, ivec3 P, uint data);
uint imageAtomicOr(imageCubeArray image, ivec3 P, uint data);
uint imageAtomicOr(iimageCubeArray image, ivec3 P, uint data);
uint imageAtomicOr(uimageCubeArray image, ivec3 P, uint data);
uint imageAtomicOr(image1D image, int P, uint data);
uint imageAtomicOr(iimage1D image, int P, uint data);
uint imageAtomicOr(uimage1D image, int P, uint data);
uint imageAtomicOr(image1DArray image, ivec2 P, uint data);
uint imageAtomicOr(iimage1DArray image, ivec2 P, uint data);
uint imageAtomicOr(uimage1DArray image, ivec2 P, uint data);
uint imageAtomicOr(image2DRect image, ivec2 P, uint data);
uint imageAtomicOr(iimage2DRect image, ivec2 P, uint data);
uint imageAtomicOr(uimage2DRect image, ivec2 P, uint data);
uint imageAtomicOr(image2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicOr(iimage2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicOr(uimage2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicOr(image2DMSArray image, ivec3 P, int _sample, uint data);
uint imageAtomicOr(iimage2DMSArray image, ivec3 P, int _sample, uint data);
uint imageAtomicOr(uimage2DMSArray image, ivec3 P, int _sample, uint data);
int imageAtomicOr(image2D image, ivec2 P, int data);
int imageAtomicOr(iimage2D image, ivec2 P, int data);
int imageAtomicOr(uimage2D image, ivec2 P, int data);
int imageAtomicOr(image3D image, ivec3 P, int data);
int imageAtomicOr(iimage3D image, ivec3 P, int data);
int imageAtomicOr(uimage3D image, ivec3 P, int data);
int imageAtomicOr(imageCube image, ivec3 P, int data);
int imageAtomicOr(iimageCube image, ivec3 P, int data);
int imageAtomicOr(uimageCube image, ivec3 P, int data);
int imageAtomicOr(imageBuffer image, int P, int data);
int imageAtomicOr(iimageBuffer image, int P, int data);
int imageAtomicOr(uimageBuffer image, int P, int data);
int imageAtomicOr(image2DArray image, ivec3 P, int data);
int imageAtomicOr(iimage2DArray image, ivec3 P, int data);
int imageAtomicOr(uimage2DArray image, ivec3 P, int data);
int imageAtomicOr(imageCubeArray image, ivec3 P, int data);
int imageAtomicOr(iimageCubeArray image, ivec3 P, int data);
int imageAtomicOr(uimageCubeArray image, ivec3 P, int data);
int imageAtomicOr(image1D image, int P, int data);
int imageAtomicOr(iimage1D image, int P, int data);
int imageAtomicOr(uimage1D image, int P, int data);
int imageAtomicOr(image1DArray image, ivec2 P, int data);
int imageAtomicOr(iimage1DArray image, ivec2 P, int data);
int imageAtomicOr(uimage1DArray image, ivec2 P, int data);
int imageAtomicOr(image2DRect image, ivec2 P, int data);
int imageAtomicOr(iimage2DRect image, ivec2 P, int data);
int imageAtomicOr(uimage2DRect image, ivec2 P, int data);
int imageAtomicOr(image2DMS image, ivec2 P, int _sample, int data);
int imageAtomicOr(iimage2DMS image, ivec2 P, int _sample, int data);
int imageAtomicOr(uimage2DMS image, ivec2 P, int _sample, int data);
int imageAtomicOr(image2DMSArray image, ivec3 P, int _sample, int data);
int imageAtomicOr(iimage2DMSArray image, ivec3 P, int _sample, int data);
int imageAtomicOr(uimage2DMSArray image, ivec3 P, int _sample, int data);
uint imageAtomicXor(image2D image, ivec2 P, uint data);
uint imageAtomicXor(iimage2D image, ivec2 P, uint data);
uint imageAtomicXor(uimage2D image, ivec2 P, uint data);
uint imageAtomicXor(image3D image, ivec3 P, uint data);
uint imageAtomicXor(iimage3D image, ivec3 P, uint data);
uint imageAtomicXor(uimage3D image, ivec3 P, uint data);
uint imageAtomicXor(imageCube image, ivec3 P, uint data);
uint imageAtomicXor(iimageCube image, ivec3 P, uint data);
uint imageAtomicXor(uimageCube image, ivec3 P, uint data);
uint imageAtomicXor(imageBuffer image, int P, uint data);
uint imageAtomicXor(iimageBuffer image, int P, uint data);
uint imageAtomicXor(uimageBuffer image, int P, uint data);
uint imageAtomicXor(image2DArray image, ivec3 P, uint data);
uint imageAtomicXor(iimage2DArray image, ivec3 P, uint data);
uint imageAtomicXor(uimage2DArray image, ivec3 P, uint data);
uint imageAtomicXor(imageCubeArray image, ivec3 P, uint data);
uint imageAtomicXor(iimageCubeArray image, ivec3 P, uint data);
uint imageAtomicXor(uimageCubeArray image, ivec3 P, uint data);
uint imageAtomicXor(image1D image, int P, uint data);
uint imageAtomicXor(iimage1D image, int P, uint data);
uint imageAtomicXor(uimage1D image, int P, uint data);
uint imageAtomicXor(image1DArray image, ivec2 P, uint data);
uint imageAtomicXor(iimage1DArray image, ivec2 P, uint data);
uint imageAtomicXor(uimage1DArray image, ivec2 P, uint data);
uint imageAtomicXor(image2DRect image, ivec2 P, uint data);
uint imageAtomicXor(iimage2DRect image, ivec2 P, uint data);
uint imageAtomicXor(uimage2DRect image, ivec2 P, uint data);
uint imageAtomicXor(image2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicXor(iimage2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicXor(uimage2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicXor(image2DMSArray image, ivec3 P, int _sample, uint data);
uint imageAtomicXor(iimage2DMSArray image, ivec3 P, int _sample, uint data);
uint imageAtomicXor(uimage2DMSArray image, ivec3 P, int _sample, uint data);
int imageAtomicXor(image2D image, ivec2 P, int data);
int imageAtomicXor(iimage2D image, ivec2 P, int data);
int imageAtomicXor(uimage2D image, ivec2 P, int data);
int imageAtomicXor(image3D image, ivec3 P, int data);
int imageAtomicXor(iimage3D image, ivec3 P, int data);
int imageAtomicXor(uimage3D image, ivec3 P, int data);
int imageAtomicXor(imageCube image, ivec3 P, int data);
int imageAtomicXor(iimageCube image, ivec3 P, int data);
int imageAtomicXor(uimageCube image, ivec3 P, int data);
int imageAtomicXor(imageBuffer image, int P, int data);
int imageAtomicXor(iimageBuffer image, int P, int data);
int imageAtomicXor(uimageBuffer image, int P, int data);
int imageAtomicXor(image2DArray image, ivec3 P, int data);
int imageAtomicXor(iimage2DArray image, ivec3 P, int data);
int imageAtomicXor(uimage2DArray image, ivec3 P, int data);
int imageAtomicXor(imageCubeArray image, ivec3 P, int data);
int imageAtomicXor(iimageCubeArray image, ivec3 P, int data);
int imageAtomicXor(uimageCubeArray image, ivec3 P, int data);
int imageAtomicXor(image1D image, int P, int data);
int imageAtomicXor(iimage1D image, int P, int data);
int imageAtomicXor(uimage1D image, int P, int data);
int imageAtomicXor(image1DArray image, ivec2 P, int data);
int imageAtomicXor(iimage1DArray image, ivec2 P, int data);
int imageAtomicXor(uimage1DArray image, ivec2 P, int data);
int imageAtomicXor(image2DRect image, ivec2 P, int data);
int imageAtomicXor(iimage2DRect image, ivec2 P, int data);
int imageAtomicXor(uimage2DRect image, ivec2 P, int data);
int imageAtomicXor(image2DMS image, ivec2 P, int _sample, int data);
int imageAtomicXor(iimage2DMS image, ivec2 P, int _sample, int data);
int imageAtomicXor(uimage2DMS image, ivec2 P, int _sample, int data);
int imageAtomicXor(image2DMSArray image, ivec3 P, int _sample, int data);
int imageAtomicXor(iimage2DMSArray image, ivec3 P, int _sample, int data);
int imageAtomicXor(uimage2DMSArray image, ivec3 P, int _sample, int data);
uint imageAtomicExchange(image2D image, ivec2 P, uint data);
uint imageAtomicExchange(iimage2D image, ivec2 P, uint data);
uint imageAtomicExchange(uimage2D image, ivec2 P, uint data);
uint imageAtomicExchange(image3D image, ivec3 P, uint data);
uint imageAtomicExchange(iimage3D image, ivec3 P, uint data);
uint imageAtomicExchange(uimage3D image, ivec3 P, uint data);
uint imageAtomicExchange(imageCube image, ivec3 P, uint data);
uint imageAtomicExchange(iimageCube image, ivec3 P, uint data);
uint imageAtomicExchange(uimageCube image, ivec3 P, uint data);
uint imageAtomicExchange(imageBuffer image, int P, uint data);
uint imageAtomicExchange(iimageBuffer image, int P, uint data);
uint imageAtomicExchange(uimageBuffer image, int P, uint data);
uint imageAtomicExchange(image2DArray image, ivec3 P, uint data);
uint imageAtomicExchange(iimage2DArray image, ivec3 P, uint data);
uint imageAtomicExchange(uimage2DArray image, ivec3 P, uint data);
uint imageAtomicExchange(imageCubeArray image, ivec3 P, uint data);
uint imageAtomicExchange(iimageCubeArray image, ivec3 P, uint data);
uint imageAtomicExchange(uimageCubeArray image, ivec3 P, uint data);
uint imageAtomicExchange(image1D image, int P, uint data);
uint imageAtomicExchange(iimage1D image, int P, uint data);
uint imageAtomicExchange(uimage1D image, int P, uint data);
uint imageAtomicExchange(image1DArray image, ivec2 P, uint data);
uint imageAtomicExchange(iimage1DArray image, ivec2 P, uint data);
uint imageAtomicExchange(uimage1DArray image, ivec2 P, uint data);
uint imageAtomicExchange(image2DRect image, ivec2 P, uint data);
uint imageAtomicExchange(iimage2DRect image, ivec2 P, uint data);
uint imageAtomicExchange(uimage2DRect image, ivec2 P, uint data);
uint imageAtomicExchange(image2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicExchange(iimage2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicExchange(uimage2DMS image, ivec2 P, int _sample, uint data);
uint imageAtomicExchange(image2DMSArray image, ivec3 P, int _sample, uint data);
uint imageAtomicExchange(iimage2DMSArray image, ivec3 P, int _sample, uint data);
uint imageAtomicExchange(uimage2DMSArray image, ivec3 P, int _sample, uint data);
int imageAtomicExchange(image2D image, ivec2 P, int data);
int imageAtomicExchange(iimage2D image, ivec2 P, int data);
int imageAtomicExchange(uimage2D image, ivec2 P, int data);
int imageAtomicExchange(image3D image, ivec3 P, int data);
int imageAtomicExchange(iimage3D image, ivec3 P, int data);
int imageAtomicExchange(uimage3D image, ivec3 P, int data);
int imageAtomicExchange(imageCube image, ivec3 P, int data);
int imageAtomicExchange(iimageCube image, ivec3 P, int data);
int imageAtomicExchange(uimageCube image, ivec3 P, int data);
int imageAtomicExchange(imageBuffer image, int P, int data);
int imageAtomicExchange(iimageBuffer image, int P, int data);
int imageAtomicExchange(uimageBuffer image, int P, int data);
int imageAtomicExchange(image2DArray image, ivec3 P, int data);
int imageAtomicExchange(iimage2DArray image, ivec3 P, int data);
int imageAtomicExchange(uimage2DArray image, ivec3 P, int data);
int imageAtomicExchange(imageCubeArray image, ivec3 P, int data);
int imageAtomicExchange(iimageCubeArray image, ivec3 P, int data);
int imageAtomicExchange(uimageCubeArray image, ivec3 P, int data);
int imageAtomicExchange(image1D image, int P, int data);
int imageAtomicExchange(iimage1D image, int P, int data);
int imageAtomicExchange(uimage1D image, int P, int data);
int imageAtomicExchange(image1DArray image, ivec2 P, int data);
int imageAtomicExchange(iimage1DArray image, ivec2 P, int data);
int imageAtomicExchange(uimage1DArray image, ivec2 P, int data);
int imageAtomicExchange(image2DRect image, ivec2 P, int data);
int imageAtomicExchange(iimage2DRect image, ivec2 P, int data);
int imageAtomicExchange(uimage2DRect image, ivec2 P, int data);
int imageAtomicExchange(image2DMS image, ivec2 P, int _sample, int data);
int imageAtomicExchange(iimage2DMS image, ivec2 P, int _sample, int data);
int imageAtomicExchange(uimage2DMS image, ivec2 P, int _sample, int data);
int imageAtomicExchange(image2DMSArray image, ivec3 P, int _sample, int data);
int imageAtomicExchange(iimage2DMSArray image, ivec3 P, int _sample, int data);
int imageAtomicExchange(uimage2DMSArray image, ivec3 P, int _sample, int data);
float imageAtomicExchange(image2D image, ivec2 P, float data);
float imageAtomicExchange(iimage2D image, ivec2 P, float data);
float imageAtomicExchange(uimage2D image, ivec2 P, float data);
float imageAtomicExchange(image3D image, ivec3 P, float data);
float imageAtomicExchange(iimage3D image, ivec3 P, float data);
float imageAtomicExchange(uimage3D image, ivec3 P, float data);
float imageAtomicExchange(imageCube image, ivec3 P, float data);
float imageAtomicExchange(iimageCube image, ivec3 P, float data);
float imageAtomicExchange(uimageCube image, ivec3 P, float data);
float imageAtomicExchange(imageBuffer image, int P, float data);
float imageAtomicExchange(iimageBuffer image, int P, float data);
float imageAtomicExchange(uimageBuffer image, int P, float data);
float imageAtomicExchange(image2DArray image, ivec3 P, float data);
float imageAtomicExchange(iimage2DArray image, ivec3 P, float data);
float imageAtomicExchange(uimage2DArray image, ivec3 P, float data);
float imageAtomicExchange(imageCubeArray image, ivec3 P, float data);
float imageAtomicExchange(iimageCubeArray image, ivec3 P, float data);
float imageAtomicExchange(uimageCubeArray image, ivec3 P, float data);
float imageAtomicExchange(image1D image, int P, float data);
float imageAtomicExchange(iimage1D image, int P, float data);
float imageAtomicExchange(uimage1D image, int P, float data);
float imageAtomicExchange(image1DArray image, ivec2 P, float data);
float imageAtomicExchange(iimage1DArray image, ivec2 P, float data);
float imageAtomicExchange(uimage1DArray image, ivec2 P, float data);
float imageAtomicExchange(image2DRect image, ivec2 P, float data);
float imageAtomicExchange(iimage2DRect image, ivec2 P, float data);
float imageAtomicExchange(uimage2DRect image, ivec2 P, float data);
float imageAtomicExchange(image2DMS image, ivec2 P, int _sample, float data);
float imageAtomicExchange(iimage2DMS image, ivec2 P, int _sample, float data);
float imageAtomicExchange(uimage2DMS image, ivec2 P, int _sample, float data);
float imageAtomicExchange(image2DMSArray image, ivec3 P, int _sample, float data);
float imageAtomicExchange(iimage2DMSArray image, ivec3 P, int _sample, float data);
float imageAtomicExchange(uimage2DMSArray image, ivec3 P, int _sample, float data);
uint imageAtomicCompSwap(image2D image, ivec2 P, uint compare, uint data);
uint imageAtomicCompSwap(iimage2D image, ivec2 P, uint compare, uint data);
uint imageAtomicCompSwap(uimage2D image, ivec2 P, uint compare, uint data);
uint imageAtomicCompSwap(image3D image, ivec3 P, uint compare, uint data);
uint imageAtomicCompSwap(iimage3D image, ivec3 P, uint compare, uint data);
uint imageAtomicCompSwap(uimage3D image, ivec3 P, uint compare, uint data);
uint imageAtomicCompSwap(imageCube image, ivec3 P, uint compare, uint data);
uint imageAtomicCompSwap(iimageCube image, ivec3 P, uint compare, uint data);
uint imageAtomicCompSwap(uimageCube image, ivec3 P, uint compare, uint data);
uint imageAtomicCompSwap(imageBuffer image, int P, uint compare, uint data);
uint imageAtomicCompSwap(iimageBuffer image, int P, uint compare, uint data);
uint imageAtomicCompSwap(uimageBuffer image, int P, uint compare, uint data);
uint imageAtomicCompSwap(image2DArray image, ivec3 P, uint compare, uint data);
uint imageAtomicCompSwap(iimage2DArray image, ivec3 P, uint compare, uint data);
uint imageAtomicCompSwap(uimage2DArray image, ivec3 P, uint compare, uint data);
uint imageAtomicCompSwap(imageCubeArray image, ivec3 P, uint compare, uint data);
uint imageAtomicCompSwap(iimageCubeArray image, ivec3 P, uint compare, uint data);
uint imageAtomicCompSwap(uimageCubeArray image, ivec3 P, uint compare, uint data);
uint imageAtomicCompSwap(image1D image, int P, uint compare, uint data);
uint imageAtomicCompSwap(iimage1D image, int P, uint compare, uint data);
uint imageAtomicCompSwap(uimage1D image, int P, uint compare, uint data);
uint imageAtomicCompSwap(image1DArray image, ivec2 P, uint compare, uint data);
uint imageAtomicCompSwap(iimage1DArray image, ivec2 P, uint compare, uint data);
uint imageAtomicCompSwap(uimage1DArray image, ivec2 P, uint compare, uint data);
uint imageAtomicCompSwap(image2DRect image, ivec2 P, uint compare, uint data);
uint imageAtomicCompSwap(iimage2DRect image, ivec2 P, uint compare, uint data);
uint imageAtomicCompSwap(uimage2DRect image, ivec2 P, uint compare, uint data);
uint imageAtomicCompSwap(image2DMS image, ivec2 P, int _sample, uint compare, uint data);
uint imageAtomicCompSwap(iimage2DMS image, ivec2 P, int _sample, uint compare, uint data);
uint imageAtomicCompSwap(uimage2DMS image, ivec2 P, int _sample, uint compare, uint data);
uint imageAtomicCompSwap(image2DMSArray image, ivec3 P, int _sample, uint compare, uint data);
uint imageAtomicCompSwap(iimage2DMSArray image, ivec3 P, int _sample, uint compare, uint data);
uint imageAtomicCompSwap(uimage2DMSArray image, ivec3 P, int _sample, uint compare, uint data);
int imageAtomicCompSwap(image2D image, ivec2 P, int compare, int data);
int imageAtomicCompSwap(iimage2D image, ivec2 P, int compare, int data);
int imageAtomicCompSwap(uimage2D image, ivec2 P, int compare, int data);
int imageAtomicCompSwap(image3D image, ivec3 P, int compare, int data);
int imageAtomicCompSwap(iimage3D image, ivec3 P, int compare, int data);
int imageAtomicCompSwap(uimage3D image, ivec3 P, int compare, int data);
int imageAtomicCompSwap(imageCube image, ivec3 P, int compare, int data);
int imageAtomicCompSwap(iimageCube image, ivec3 P, int compare, int data);
int imageAtomicCompSwap(uimageCube image, ivec3 P, int compare, int data);
int imageAtomicCompSwap(imageBuffer image, int P, int compare, int data);
int imageAtomicCompSwap(iimageBuffer image, int P, int compare, int data);
int imageAtomicCompSwap(uimageBuffer image, int P, int compare, int data);
int imageAtomicCompSwap(image2DArray image, ivec3 P, int compare, int data);
int imageAtomicCompSwap(iimage2DArray image, ivec3 P, int compare, int data);
int imageAtomicCompSwap(uimage2DArray image, ivec3 P, int compare, int data);
int imageAtomicCompSwap(imageCubeArray image, ivec3 P, int compare, int data);
int imageAtomicCompSwap(iimageCubeArray image, ivec3 P, int compare, int data);
int imageAtomicCompSwap(uimageCubeArray image, ivec3 P, int compare, int data);
int imageAtomicCompSwap(image1D image, int P, int compare, int data);
int imageAtomicCompSwap(iimage1D image, int P, int compare, int data);
int imageAtomicCompSwap(uimage1D image, int P, int compare, int data);
int imageAtomicCompSwap(image1DArray image, ivec2 P, int compare, int data);
int imageAtomicCompSwap(iimage1DArray image, ivec2 P, int compare, int data);
int imageAtomicCompSwap(uimage1DArray image, ivec2 P, int compare, int data);
int imageAtomicCompSwap(image2DRect image, ivec2 P, int compare, int data);
int imageAtomicCompSwap(iimage2DRect image, ivec2 P, int compare, int data);
int imageAtomicCompSwap(uimage2DRect image, ivec2 P, int compare, int data);
int imageAtomicCompSwap(image2DMS image, ivec2 P, int _sample, int compare, int data);
int imageAtomicCompSwap(iimage2DMS image, ivec2 P, int _sample, int compare, int data);
int imageAtomicCompSwap(uimage2DMS image, ivec2 P, int _sample, int compare, int data);
int imageAtomicCompSwap(image2DMSArray image, ivec3 P, int _sample, int compare, int data);
int imageAtomicCompSwap(iimage2DMSArray image, ivec3 P, int _sample, int compare, int data);
int imageAtomicCompSwap(uimage2DMSArray image, ivec3 P, int _sample, int compare, int data);

// Shader invocation control functions.
void barrier();

// Shader memory control functions.
void memoryBarrier();
void memoryBarrierAtomicCounter();
void memoryBarrierBuffer();
void memoryBarrierShared();
void memoryBarrierImage();
void groupMemoryBarrier();

// Shader invocation group functions. (optional)
bool anyInvocation(bool value);
bool allInvocations(bool value);
bool allInvocationsEqual(bool value);


//// Vulkan removed variables and functions

// Built-in uniform state.
struct gl_DepthRangeParameters {
    highp float near;
    highp float far;
    highp float diff;
};
uniform gl_DepthRangeParameters gl_DepthRange;
uniform lowp int gl_NumSamples;


// Deprecated texture functions.
vec4 texture1D(sampler1D _sampler, float coord);
vec4 texture1D(sampler1D _sampler, float coord, float bias);
vec4 texture1DProj(sampler1D _sampler, vec2 coord);
vec4 texture1DProj(sampler1D _sampler, vec2 coord, float bias);
vec4 texture1DProj(sampler1D _sampler, vec4 coord);
vec4 texture1DProj(sampler1D _sampler, vec4 coord, float bias);
vec4 texture1DLod(sampler1D _sampler, float coord, float lod);
vec4 texture1DProjLod(sampler1D _sampler, vec2 coord, float lod);
vec4 texture1DProjLod(sampler1D _sampler, vec4 coord, float lod);
vec4 texture2D(sampler2D _sampler, vec2 coord);
vec4 texture2D(sampler2D _sampler, vec2 coord, float bias);
vec4 texture2DProj(sampler2D _sampler, vec3 coord);
vec4 texture2DProj(sampler2D _sampler, vec3 coord, float bias);
vec4 texture2DProj(sampler2D _sampler, vec4 coord);
vec4 texture2DProj(sampler2D _sampler, vec4 coord, float bias);
vec4 texture2DLod(sampler2D _sampler, vec2 coord, float lod);
vec4 texture2DProjLod(sampler2D _sampler, vec3 coord, float lod);
vec4 texture2DProjLod(sampler2D _sampler, vec4 coord, float lod);
vec4 texture3D(sampler3D _sampler, vec3 coord);
vec4 texture3D(sampler3D _sampler, vec3 coord, float bias);
vec4 texture3DProj(sampler3D _sampler, vec4 coord);
vec4 texture3DProj(sampler3D _sampler, vec4 coord, float bias);
vec4 texture3DLod(sampler3D _sampler, vec3 coord, float lod);
vec4 texture3DProjLod(sampler3D _sampler, vec4 coord, float lod);
vec4 textureCube(samplerCube _sampler, vec3 coord);
vec4 textureCube(samplerCube _sampler, vec3 coord, float bias);
vec4 textureCubeLod(samplerCube _sampler, vec3 coord, float lod);
vec4 shadow1D(sampler1DShadow _sampler, vec3 coord);
vec4 shadow1D(sampler1DShadow _sampler, vec3 coord, float bias);
vec4 shadow2D(sampler2DShadow _sampler, vec3 coord);
vec4 shadow2D(sampler2DShadow _sampler, vec3 coord, float bias);
vec4 shadow1DProj(sampler1DShadow _sampler, vec4 coord);
vec4 shadow1DProj(sampler1DShadow _sampler, vec4 coord, float bias);
vec4 shadow2DProj(sampler2DShadow _sampler, vec4 coord);
vec4 shadow2DProj(sampler2DShadow _sampler, vec4 coord, float bias);
vec4 shadow1DLod(sampler1DShadow _sampler, vec3 coord, float lod);
vec4 shadow2DLod(sampler2DShadow _sampler, vec3 coord, float lod);
vec4 shadow1DProjLod(sampler1DShadow _sampler, vec4 coord, float lod);
vec4 shadow2DProjLod(sampler2DShadow _sampler, vec4 coord, float lod);

// Noise functions.
float noise1(float x);
float noise1(vec2 x);
float noise1(vec3 x);
float noise1(vec4 x);
vec2 noise2(float x);
vec2 noise2(vec2 x);
vec2 noise2(vec3 x);
vec2 noise2(vec4 x);
vec3 noise3(float x);
vec3 noise3(vec2 x);
vec3 noise3(vec3 x);
vec3 noise3(vec4 x);
vec4 noise4(float x);
vec4 noise4(vec2 x);
vec4 noise4(vec3 x);
vec4 noise4(vec4 x);
